/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.jai.GeneralFilterFunction;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public final class GeneralFilterOpImage
extends AreaOpImage {
    private final GeneralFilterFunction filterFunction;

    public GeneralFilterOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, GeneralFilterFunction filterFunction) {
        super(source, layout, config, true, extender, filterFunction.getLeftPadding(), filterFunction.getRightPadding(), filterFunction.getTopPadding(), filterFunction.getBottomPadding());
        this.filterFunction = filterFunction;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, dstAccessor);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, dstAccessor);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, dstAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, dstAccessor);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            byte[] dstData = dstDataArrays[k];
            byte[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = srcData[imageOffset] & 0xFF;
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    int val = (int)this.filterFunction.filter(fdata);
                    if (val < 0) {
                        val = 0;
                    } else if (val > 255) {
                        val = 255;
                    }
                    dstData[dstPixelOffset] = (byte)val;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void shortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            short[] dstData = dstDataArrays[k];
            short[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = srcData[imageOffset];
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    int val = (int)this.filterFunction.filter(fdata);
                    if (val < Short.MIN_VALUE) {
                        val = Short.MIN_VALUE;
                    } else if (val > Short.MAX_VALUE) {
                        val = Short.MAX_VALUE;
                    }
                    dstData[dstPixelOffset] = (short)val;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            short[] dstData = dstDataArrays[k];
            short[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = srcData[imageOffset] & 0xFFFF;
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    int val = (int)this.filterFunction.filter(fdata);
                    if (val < 0) {
                        val = 0;
                    } else if (val > 65535) {
                        val = 65535;
                    }
                    dstData[dstPixelOffset] = (short)val;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void intLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            int[] dstData = dstDataArrays[k];
            int[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = srcData[imageOffset];
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    dstData[dstPixelOffset] = (int)this.filterFunction.filter(fdata);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void floatLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            float[] dstData = dstDataArrays[k];
            float[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = srcData[imageOffset];
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    dstData[dstPixelOffset] = this.filterFunction.filter(fdata);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void doubleLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int fw = this.filterFunction.getWidth();
        int fh = this.filterFunction.getHeight();
        float[] fdata = new float[fw * fh];
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int k = 0;
        while (k < dnumBands) {
            double[] dstData = dstDataArrays[k];
            double[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < dheight) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < dwidth) {
                    int filterVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < fh) {
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < fw) {
                            fdata[filterVerticalOffset + v] = (float)srcData[imageOffset];
                            imageOffset += srcPixelStride;
                            ++v;
                        }
                        filterVerticalOffset += fw;
                        imageVerticalOffset += srcScanlineStride;
                        ++u;
                    }
                    dstData[dstPixelOffset] = this.filterFunction.filter(fdata);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
            }
            ++k;
        }
    }
}

