/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.calibration;

import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.AvhrrReader;
import org.esa.beam.dataio.avhrr.calibration.AbstractCalibrator;
import org.esa.beam.util.Guardian;

public class IrRadianceCalibrator
extends AbstractCalibrator {
    private static final int[] OPERATIONAL_DATA_OFFSET = new int[]{45, 51, 57};
    private static final float[] SCALING_FACTORS_666 = new float[]{1.0E-6f, 1.0E-6f, 1.0E-6f};
    private static final float[] SCALING_FACTORS_667 = new float[]{1.0E-6f, 1.0E-6f, 1.0E-7f};
    private int operationalDataIndex;
    private float[] scalingFactors;
    private double a1;
    private double a2;
    private double a3;

    public IrRadianceCalibrator(int channel) {
        super(channel);
        Guardian.assertWithinRange("channel", channel, 3L, 5L);
        this.operationalDataIndex = channel - 3;
    }

    @Override
    public String getBandName() {
        return "radiance_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        return "mW / (m^2 sr cm^-1)";
    }

    @Override
    public String getBandDescription() {
        return AvhrrReader.format("Earth scene radiance for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public boolean requiresCalibrationData() {
        return true;
    }

    @Override
    public boolean processCalibrationData(int[] calibrationData) {
        boolean valid;
        int offset = OPERATIONAL_DATA_OFFSET[this.operationalDataIndex];
        boolean bl = valid = calibrationData[offset] != 0 && calibrationData[offset + 1] != 0;
        if (valid) {
            this.a1 = (float)calibrationData[offset] * this.scalingFactors[0];
            this.a2 = (float)calibrationData[offset + 1] * this.scalingFactors[1];
            this.a3 = (float)calibrationData[offset + 2] * this.scalingFactors[2];
        }
        return valid;
    }

    @Override
    public float calibrate(int counts) {
        double ne = this.a1 + this.a2 * (double)counts + this.a3 * (double)counts * (double)counts;
        return (float)ne;
    }

    public void setFormatVersion(int formatVersion) {
        this.scalingFactors = formatVersion == 2 || formatVersion == 3 && this.channel == 3 ? SCALING_FACTORS_666 : SCALING_FACTORS_667;
    }
}

