/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import org.esa.beam.dataio.avhrr.noaa.FormatMetadata;
import org.esa.beam.dataio.avhrr.noaa.TypeUtils;

final class PodTypes {
    private static final CompoundType TIME_CODE_TYPE = TypeBuilder.COMPOUND("TIME_CODE", TypeBuilder.MEMBER("YEAR_DAY", SimpleType.USHORT), TypeBuilder.MEMBER("MILLISECONDS", SimpleType.UINT));
    private static final CompoundType CALIBRATION_COEFFICIENTS_TYPE = TypeBuilder.COMPOUND("", TypeUtils.META_MEMBER("SLOPE", SimpleType.INT, TypeUtils.META().setScalingFactor(9.313225746154785E-10)), TypeUtils.META_MEMBER("INTERCEPT", SimpleType.INT, TypeUtils.META().setScalingFactor(2.384185791015625E-7)));
    private static final CompoundType EARTH_LOCATION_TYPE = TypeBuilder.COMPOUND("", TypeUtils.META_MEMBER("LAT", SimpleType.SHORT, TypeUtils.META().setScalingFactor(0.0078125).setUnits("degrees north")), TypeUtils.META_MEMBER("LON", SimpleType.SHORT, TypeUtils.META().setScalingFactor(0.0078125).setUnits("degrees east")));
    private static final CompoundType KEPLERIAN_ORBITAL_ELEMENTS_TYPE = TypeBuilder.COMPOUND("KEPLERIAN_ORBITAL_ELEMENTS", TypeUtils.META_MEMBER("SEMI_MAJOR_AXIS", SimpleType.UINT, TypeUtils.META().setScalingFactor(0.001).setUnits("km")), TypeUtils.META_MEMBER("ECCENTRICITY", SimpleType.UINT, TypeUtils.META().setScalingFactor(1.0E-8)), TypeUtils.META_MEMBER("INCLINATION", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("ARGUMENT_OF_PERIGEE", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("RIGHT_ASCENSION_OF_THE_ASCENDING_NODE", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("MEAN_ANOMALY", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")));
    private static final CompoundType CARTESIAN_INERTIAL_ELEMENTS_TYPE = TypeBuilder.COMPOUND("CARTESIAN_INERTIAL_ELEMENTS", TypeUtils.META_MEMBER("X", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("Y", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("Z", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("U", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1")), TypeUtils.META_MEMBER("V", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1")), TypeUtils.META_MEMBER("W", SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1")));
    private static final CompoundType DUMMY_RECORD_TYPE = TypeBuilder.COMPOUND("DUMMY_RECORD", TypeUtils.FILL_MEMBER(7400));
    static final CompoundType TBM_HEADER_RECORD_TYPE = TypeBuilder.COMPOUND("TBM_HEADER_RECORD", TypeUtils.FILL_MEMBER(30), TypeUtils.STRING_MEMBER("DATASET_NAME", 44), TypeUtils.STRING_MEMBER("TOTAL_OR_SELECTIVE_COPY", 1), TypeUtils.STRING_MEMBER("BEGINNING_LATITUDE", 3), TypeUtils.STRING_MEMBER("ENDING_LATITUDE", 3), TypeUtils.STRING_MEMBER("BEGINNING_LONGITUDE", 4), TypeUtils.STRING_MEMBER("ENDING_LONGITUDE", 4), TypeUtils.STRING_MEMBER("START_HOUR", 2), TypeUtils.STRING_MEMBER("START_MINUTE", 2), TypeUtils.STRING_MEMBER("NUMBER_OF_MINUTES", 3), TypeUtils.STRING_MEMBER("APPENDED_DATA_SELECTION", 1), TypeBuilder.MEMBER("CHANNELS_SELECTED", TypeBuilder.SEQUENCE(SimpleType.UBYTE, 20)), TypeUtils.STRING_MEMBER("SENSOR_DATA_WORD_SIZE", 2), TypeUtils.FILL_MEMBER(3));
    static final CompoundType DATASET_HEADER_RECORD_TYPE = TypeBuilder.COMPOUND("DATASET_HEADER_RECORD", TypeUtils.STRING_MEMBER("PROCESSING_BLOCK_ID", 7), TypeBuilder.MEMBER("RAMP_AUTO_CALIBRATION", SimpleType.UBYTE), TypeBuilder.MEMBER("NUMBER_OF_DATA_GAPS", SimpleType.USHORT), TypeBuilder.MEMBER("DACS_QUALITY", TypeBuilder.SEQUENCE(SimpleType.USHORT, 3)), TypeUtils.STRING_MEMBER("CALIBRATION_PARAMETER_ID", 2), TypeBuilder.MEMBER("DACS_STATUS", SimpleType.UBYTE), TypeBuilder.MEMBER("MOUNTING_AND_FIXED_ATTITUDE_INDICATOR", SimpleType.UBYTE), TypeBuilder.MEMBER("NADIR_EARTH_LOCATION_TOLERANCE", SimpleType.UBYTE), TypeUtils.FILL_MEMBER(1), TypeBuilder.MEMBER("YEAR_FOR_START_OF_DATA", SimpleType.USHORT), TypeUtils.STRING_MEMBER("DATASET_NAME", 44), TypeBuilder.MEMBER("YEAR_OF_EPOCH_FOR_ORBIT_VECTOR", SimpleType.USHORT), TypeBuilder.MEMBER("JULIAN_DAY_OF_EPOCH", SimpleType.USHORT), TypeBuilder.MEMBER("MILLISECOND_UTC_EPOCH_TIME_OF_DAY", SimpleType.UINT), TypeBuilder.MEMBER("KEPLERIAN_ORBITAL_ELEMENTS", KEPLERIAN_ORBITAL_ELEMENTS_TYPE), TypeBuilder.MEMBER("CARTESIAN_INERTIAL_ELEMENTS", CARTESIAN_INERTIAL_ELEMENTS_TYPE), TypeBuilder.MEMBER("YAW_FIXED_ERROR_CORRECTION", SimpleType.SHORT), TypeBuilder.MEMBER("ROLL_FIXED_ERROR_CORRECTION", SimpleType.SHORT), TypeBuilder.MEMBER("PITCH_FIXED_ERROR_CORRECTION", SimpleType.SHORT), TypeUtils.FILL_MEMBER(7308 - KEPLERIAN_ORBITAL_ELEMENTS_TYPE.getSize() - CARTESIAN_INERTIAL_ELEMENTS_TYPE.getSize() - 2 - 2 - 2));
    static final CompoundType DATA_RECORD_TYPE = TypeBuilder.COMPOUND("DATA_RECORD", TypeBuilder.MEMBER("SCAN_LINE_NUMBER", SimpleType.USHORT), TypeBuilder.MEMBER("TIME_CODE", TIME_CODE_TYPE), TypeBuilder.MEMBER("QUALITY_INDICATORS", SimpleType.UINT), TypeBuilder.MEMBER("CALIBRATION_COEFFICIENTS", TypeBuilder.SEQUENCE(CALIBRATION_COEFFICIENTS_TYPE, 5)), TypeBuilder.MEMBER("NUMBER_OF_MEANINGFUL_ZENITH_ANGLES_AND_EARTH_LOCATION_POINTS", SimpleType.UBYTE), TypeUtils.META_MEMBER("SOLAR_ZENITH_ANGLES", TypeBuilder.SEQUENCE(SimpleType.UBYTE, 51), TypeUtils.META().setScalingFactor(0.5).setUnits("degree")), TypeBuilder.MEMBER("EARTH_LOCATION", TypeBuilder.SEQUENCE(EARTH_LOCATION_TYPE, 51)), TypeBuilder.MEMBER("TELEMETRY", TypeBuilder.SEQUENCE(SimpleType.UBYTE, 140)), TypeBuilder.MEMBER("VIDEO_DATA", TypeBuilder.SEQUENCE(SimpleType.UINT, 3414)), TypeBuilder.MEMBER("DECIMAL_PORTION_OF_SOLAR_ZENITH_ANGLES", TypeBuilder.SEQUENCE(SimpleType.UBYTE, 20)), TypeBuilder.MEMBER("CLOCK_DRIFT_DELTA", SimpleType.USHORT), TypeUtils.FILL_MEMBER(674));
    static final CompoundType HRPT_TYPE = TypeBuilder.COMPOUND("HRPT", TypeBuilder.MEMBER("TBM_HEADER_RECORD", TBM_HEADER_RECORD_TYPE), TypeBuilder.MEMBER("SPACECRAFT_ID", SimpleType.UBYTE), TypeBuilder.MEMBER("DATA_TYPE", SimpleType.UBYTE), TypeBuilder.MEMBER("START_TIME", TIME_CODE_TYPE), TypeBuilder.MEMBER("NUMBER_OF_SCANS", SimpleType.USHORT), TypeBuilder.MEMBER("END_TIME", TIME_CODE_TYPE), TypeBuilder.MEMBER("DATASET_HEADER_RECORD", DATASET_HEADER_RECORD_TYPE), TypeBuilder.MEMBER("DUMMY_RECORD", DUMMY_RECORD_TYPE), TypeBuilder.MEMBER("DATA_RECORDS", TypeBuilder.VAR_SEQUENCE((Type)DATA_RECORD_TYPE, "NUMBER_OF_SCANS")));

    PodTypes() {
    }

    static FormatMetadata getSolarZenithAnglesMetadata() {
        return (FormatMetadata)DATA_RECORD_TYPE.getMember(5).getMetadata();
    }

    static FormatMetadata getLatMetadata() {
        return (FormatMetadata)EARTH_LOCATION_TYPE.getMember(0).getMetadata();
    }

    static FormatMetadata getLonMetadata() {
        return (FormatMetadata)EARTH_LOCATION_TYPE.getMember(1).getMetadata();
    }

    static FormatMetadata getSlopeMetadata() {
        return (FormatMetadata)CALIBRATION_COEFFICIENTS_TYPE.getMember(0).getMetadata();
    }

    static FormatMetadata getInterceptMetadata() {
        return (FormatMetadata)CALIBRATION_COEFFICIENTS_TYPE.getMember(1).getMetadata();
    }
}

