/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.bc.ceres.core.Assert;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.esa.beam.dataio.geotiff.internal.GeoKeyEntry;
import org.esa.beam.dataio.geotiff.internal.GeoKeyHeader;
import org.esa.beam.framework.dataio.ProductIOException;

class TiffFileInfo {
    private static final int TAG_GEO_KEY_DIRECTORY___SPOT = 34735;
    private static final int TAG_GEO_DOUBLE_PARAMS___SPOT = 34736;
    private static final int TAG_GEO_ASCII_PARAMS___SPOT = 34737;
    private final Map<Integer, TIFFField> fieldMap;

    TiffFileInfo(TIFFDirectory dir) {
        Assert.notNull(dir);
        TIFFField[] tiffFields = dir.getTIFFFields();
        this.fieldMap = new HashMap<Integer, TIFFField>(tiffFields.length);
        TIFFField[] tIFFFieldArray = tiffFields;
        int n = tiffFields.length;
        int n2 = 0;
        while (n2 < n) {
            TIFFField tiffField = tIFFFieldArray[n2];
            this.fieldMap.put(tiffField.getTagNumber(), tiffField);
            ++n2;
        }
    }

    public boolean isGeotiff() {
        return this.fieldMap.containsKey(34735);
    }

    public TIFFField getField(int tagNumber) {
        return this.fieldMap.get(tagNumber);
    }

    public boolean containsField(int tagNumber) {
        return this.fieldMap.containsKey(tagNumber);
    }

    public static double[] getDoubleValues(TIFFField field) {
        int count = field.getCount();
        double[] doubles = new double[count];
        int i = 0;
        while (i < doubles.length) {
            doubles[i] = field.getAsDouble(i);
            ++i;
        }
        return doubles;
    }

    public static String[] getStringValues(TIFFField field) {
        int count = field.getCount();
        String[] strings = new String[count];
        int i = 0;
        while (i < strings.length) {
            strings[i] = field.getAsString(i);
            ++i;
        }
        return strings;
    }

    public SortedMap<Integer, GeoKeyEntry> getGeoKeyEntries() {
        int[] dirValues = this.getGeoKeyDirValues();
        double[] doubleValues = this.getGeoDoubleParamValues();
        String[] asciiValues = this.getGeoAsciiParamValues();
        int size = dirValues.length / 4 - 1;
        int strIdx = 0;
        TreeMap<Integer, GeoKeyEntry> map = new TreeMap<Integer, GeoKeyEntry>();
        int i = 0;
        while (i < size) {
            Object value;
            int offset = (i + 1) * 4;
            int keyId = dirValues[offset];
            int tiffTagLocation = dirValues[offset + 1];
            int count = dirValues[offset + 2];
            int offsetOrValue = dirValues[offset + 3];
            if (tiffTagLocation == 34736) {
                double[] doubles = new double[count];
                System.arraycopy(doubleValues, offsetOrValue, doubles, 0, count);
                value = doubles;
            } else {
                value = tiffTagLocation == 34737 ? asciiValues[strIdx++] : new Integer(offsetOrValue);
            }
            map.put(keyId, new GeoKeyEntry(keyId, tiffTagLocation, count, value));
            ++i;
        }
        return map;
    }

    public GeoKeyHeader getGeoKeyHeader() throws ProductIOException {
        int[] dirValues = this.getGeoKeyDirValues();
        return new GeoKeyHeader(dirValues[0], dirValues[1], dirValues[2], dirValues[3]);
    }

    private int[] getGeoKeyDirValues() {
        if (!this.containsField(34735)) {
            throw new IllegalStateException("no GEO_KEY_DIRECTORY");
        }
        TIFFField field = this.getField(34735);
        int count = field.getCount();
        int[] ints = new int[count];
        int i = 0;
        while (i < ints.length) {
            ints[i] = field.getAsInt(i);
            ++i;
        }
        return ints;
    }

    private double[] getGeoDoubleParamValues() {
        if (this.containsField(34736)) {
            return TiffFileInfo.getDoubleValues(this.getField(34736));
        }
        return new double[0];
    }

    private String[] getGeoAsciiParamValues() {
        if (this.containsField(34737)) {
            TIFFField field = this.getField(34737);
            String[] values = TiffFileInfo.getStringValues(field);
            ArrayList<String> strings = new ArrayList<String>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = value.replace("\u0000", "");
                strings.addAll(Arrays.asList(value.split("\\|")));
                ++n2;
            }
            return strings.toArray(new String[strings.size()]);
        }
        return new String[0];
    }
}

