/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.Histogram;
import org.esa.beam.framework.dataio.AbstractProductBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ProductUtils;

public class ProductSubsetBuilder
extends AbstractProductBuilder {
    public ProductSubsetBuilder() {
        this(false);
    }

    public ProductSubsetBuilder(boolean sourceProductOwner) {
        super(sourceProductOwner);
    }

    public static Product createProductSubset(Product sourceProduct, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        return ProductSubsetBuilder.createProductSubset(sourceProduct, false, subsetDef, name, desc);
    }

    public static Product createProductSubset(Product sourceProduct, boolean sourceProductOwner, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        ProductSubsetBuilder productSubsetBuilder = new ProductSubsetBuilder(sourceProductOwner);
        return productSubsetBuilder.readProductNodes(sourceProduct, subsetDef, name, desc);
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        if (!(this.getInput() instanceof Product)) {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        this.sourceProduct = (Product)this.getInput();
        Debug.assertNotNull(this.sourceProduct);
        this.sceneRasterWidth = this.sourceProduct.getSceneRasterWidth();
        this.sceneRasterHeight = this.sourceProduct.getSceneRasterHeight();
        if (this.getSubsetDef() != null) {
            Dimension s = this.getSubsetDef().getSceneRasterSize(this.sceneRasterWidth, this.sceneRasterHeight);
            this.sceneRasterWidth = s.width;
            this.sceneRasterHeight = s.height;
        }
        return this.createProduct();
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Band sourceBand = (Band)this.bandMap.get(destBand);
        if (sourceBand.getRasterData() != null) {
            if (sourceBand.getSceneRasterWidth() == destWidth && sourceBand.getSceneRasterHeight() == destHeight) {
                this.copyBandRasterDataFully(sourceBand, destBuffer, destWidth, destHeight);
            } else {
                this.copyBandRasterDataSubSampling(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destWidth);
            }
        } else if (sourceWidth == destWidth && sourceHeight == destHeight) {
            this.readBandRasterDataRegion(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
        } else {
            this.readBandRasterDataSubSampling(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destWidth, pm);
        }
    }

    private void copyBandRasterDataFully(Band sourceBand, ProductData destBuffer, int destWidth, int destHeight) {
        ProductSubsetBuilder.copyData(sourceBand.getRasterData(), 0, destBuffer, 0, destWidth * destHeight);
    }

    private void readBandRasterDataRegion(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        sourceBand.readRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
    }

    private void readBandRasterDataSubSampling(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, int destWidth, ProgressMonitor pm) throws IOException {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        ProductData lineBuffer = ProductData.createInstance(destBuffer.getType(), sourceWidth);
        int destPos = 0;
        try {
            pm.beginTask("Reading sub sampled raster data...", 2 * (sourceMaxY - sourceMinY));
            int sourceY = sourceMinY;
            while (sourceY <= sourceMaxY) {
                sourceBand.readRasterData(sourceOffsetX, sourceY, sourceWidth, 1, lineBuffer, SubProgressMonitor.create(pm, 1));
                if (sourceStepX == 1) {
                    ProductSubsetBuilder.copyData(lineBuffer, 0, destBuffer, destPos, destWidth);
                } else {
                    ProductSubsetBuilder.copyLine(lineBuffer, 0, sourceWidth, sourceStepX, destBuffer, destPos);
                }
                pm.worked(1);
                destPos += destWidth;
                sourceY += sourceStepY;
            }
        }
        finally {
            pm.done();
        }
    }

    private void copyBandRasterDataSubSampling(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, int destWidth) {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int destPos = 0;
        int sourceY = sourceMinY;
        while (sourceY <= sourceMaxY) {
            if (sourceStepX == 1) {
                ProductSubsetBuilder.copyData(sourceBand.getRasterData(), sourceY * sourceBand.getSceneRasterWidth() + sourceOffsetX, destBuffer, destPos, destWidth);
            } else {
                ProductSubsetBuilder.copyLine(sourceBand.getRasterData(), sourceY * sourceBand.getSceneRasterWidth() + sourceOffsetX, sourceWidth, sourceStepX, destBuffer, destPos);
            }
            destPos += destWidth;
            sourceY += sourceStepY;
        }
    }

    private static void copyData(ProductData sourceBuffer, int sourcePos, ProductData destBuffer, int destPos, int destLength) {
        System.arraycopy(sourceBuffer.getElems(), sourcePos, destBuffer.getElems(), destPos, destLength);
    }

    private static void copyLine(ProductData sourceBuffer, int sourceOffsetPos, int sourceWidth, int sourceStepX, ProductData destBuffer, int destOffsetPos) {
        int sourceMinX = sourceOffsetPos;
        int sourceMaxX = sourceOffsetPos + sourceWidth - 1;
        if (destBuffer.getElems() instanceof byte[]) {
            byte[] destArray = (byte[])destBuffer.getElems();
            byte[] sourceArray = (byte[])sourceBuffer.getElems();
            int sourceX = sourceMinX;
            while (sourceX <= sourceMaxX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
                sourceX += sourceStepX;
            }
        } else if (destBuffer.getElems() instanceof short[]) {
            short[] destArray = (short[])destBuffer.getElems();
            short[] sourceArray = (short[])sourceBuffer.getElems();
            int sourceX = sourceMinX;
            while (sourceX <= sourceMaxX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
                sourceX += sourceStepX;
            }
        } else if (destBuffer.getElems() instanceof int[]) {
            int[] destArray = (int[])destBuffer.getElems();
            int[] sourceArray = (int[])sourceBuffer.getElems();
            int sourceX = sourceMinX;
            while (sourceX <= sourceMaxX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
                sourceX += sourceStepX;
            }
        } else if (destBuffer.getElems() instanceof float[]) {
            float[] destArray = (float[])destBuffer.getElems();
            float[] sourceArray = (float[])sourceBuffer.getElems();
            int sourceX = sourceMinX;
            while (sourceX <= sourceMaxX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
                sourceX += sourceStepX;
            }
        } else if (destBuffer.getElems() instanceof double[]) {
            double[] destArray = (double[])destBuffer.getElems();
            double[] sourceArray = (double[])sourceBuffer.getElems();
            int sourceX = sourceMinX;
            while (sourceX <= sourceMaxX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
                sourceX += sourceStepX;
            }
        } else {
            Debug.assertTrue(false, "illegal product data type");
            throw new IllegalStateException("illegal product data type");
        }
    }

    private Product createProduct() {
        Product sourceProduct = this.getSourceProduct();
        Debug.assertNotNull(sourceProduct);
        Debug.assertTrue(this.getSceneRasterWidth() > 0);
        Debug.assertTrue(this.getSceneRasterHeight() > 0);
        String newProductName = this.newProductName == null || this.newProductName.length() == 0 ? sourceProduct.getName() : this.newProductName;
        Product product = new Product(newProductName, sourceProduct.getProductType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), this);
        product.setPointingFactory(sourceProduct.getPointingFactory());
        if (this.newProductDesc == null || this.newProductDesc.length() == 0) {
            product.setDescription(sourceProduct.getDescription());
        } else {
            product.setDescription(this.newProductDesc);
        }
        if (!this.isMetadataIgnored()) {
            ProductUtils.copyMetadata(sourceProduct, product);
        }
        this.addTiePointGridsToProduct(product);
        this.addBandsToProduct(product);
        ProductUtils.copyMasks(sourceProduct, product);
        this.addGeoCodingToProduct(product);
        ProductUtils.copyVectorData(sourceProduct, product);
        ProductUtils.copyOverlayMasks(sourceProduct, product);
        ProductUtils.copyPreferredTileSize(sourceProduct, product);
        this.setSceneRasterStartAndStopTime(product);
        this.addSubsetInfoMetadata(product);
        if (sourceProduct.getQuicklookBandName() != null && product.getQuicklookBandName() == null && product.containsBand(sourceProduct.getQuicklookBandName())) {
            product.setQuicklookBandName(sourceProduct.getQuicklookBandName());
        }
        product.setAutoGrouping(sourceProduct.getAutoGrouping());
        return product;
    }

    private void setSceneRasterStartAndStopTime(Product product) {
        Product sourceProduct = this.getSourceProduct();
        ProductData.UTC startTime = sourceProduct.getStartTime();
        ProductData.UTC stopTime = sourceProduct.getEndTime();
        ProductSubsetDef subsetDef = this.getSubsetDef();
        if (startTime != null && stopTime != null && subsetDef != null && subsetDef.getRegion() != null) {
            double height = sourceProduct.getSceneRasterHeight();
            Rectangle region = subsetDef.getRegion();
            double regionY = region.getY();
            double regionHeight = region.getHeight();
            double dStart = startTime.getMJD();
            double dStop = stopTime.getMJD();
            double vPerLine = (dStop - dStart) / (height - 1.0);
            double newStart = vPerLine * regionY + dStart;
            double newStop = vPerLine * (regionHeight - 1.0) + newStart;
            product.setStartTime(new ProductData.UTC(newStart));
            product.setEndTime(new ProductData.UTC(newStop));
        } else {
            product.setStartTime(startTime);
            product.setEndTime(stopTime);
        }
    }

    private void addSubsetInfoMetadata(Product product) {
        if (this.getSubsetDef() != null) {
            String[] nodeNames;
            ProductSubsetDef subsetDef = this.getSubsetDef();
            Product sourceProduct = this.getSourceProduct();
            String nameSubsetinfo = "SubsetInfo";
            MetadataElement subsetElem = new MetadataElement(nameSubsetinfo);
            ProductSubsetBuilder.addAttribString("SourceProduct.name", sourceProduct.getName(), subsetElem);
            subsetElem.setAttributeInt("SubSampling.x", subsetDef.getSubSamplingX());
            subsetElem.setAttributeInt("SubSampling.y", subsetDef.getSubSamplingY());
            if (subsetDef.getRegion() != null) {
                Rectangle region = subsetDef.getRegion();
                subsetElem.setAttributeInt("SubRegion.x", region.x);
                subsetElem.setAttributeInt("SubRegion.y", region.y);
                subsetElem.setAttributeInt("SubRegion.width", region.width);
                subsetElem.setAttributeInt("SubRegion.height", region.height);
            }
            if ((nodeNames = subsetDef.getNodeNames()) != null) {
                int i = 0;
                while (i < nodeNames.length) {
                    ProductSubsetBuilder.addAttribString("ProductNodeName." + (i + 1), nodeNames[i], subsetElem);
                    ++i;
                }
            }
            ProductUtils.addElementToHistory(product, subsetElem);
        }
    }

    protected void addBandsToProduct(Product product) {
        Debug.assertNotNull(this.getSourceProduct());
        Debug.assertNotNull(product);
        int i = 0;
        while (i < this.getSourceProduct().getNumBands()) {
            Band sourceBand = this.getSourceProduct().getBandAt(i);
            String bandName = sourceBand.getName();
            if (this.isNodeAccepted(bandName)) {
                Band destBand;
                boolean treatVirtualBandsAsRealBands = false;
                if (this.getSubsetDef() != null && this.getSubsetDef().getTreatVirtualBandsAsRealBands()) {
                    treatVirtualBandsAsRealBands = true;
                }
                if (!treatVirtualBandsAsRealBands && sourceBand instanceof VirtualBand) {
                    VirtualBand virtualSource = (VirtualBand)sourceBand;
                    destBand = new VirtualBand(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), virtualSource.getExpression());
                } else {
                    destBand = new Band(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight());
                }
                if (sourceBand.getUnit() != null) {
                    destBand.setUnit(sourceBand.getUnit());
                }
                if (sourceBand.getDescription() != null) {
                    destBand.setDescription(sourceBand.getDescription());
                }
                destBand.setScalingFactor(sourceBand.getScalingFactor());
                destBand.setScalingOffset(sourceBand.getScalingOffset());
                destBand.setLog10Scaled(sourceBand.isLog10Scaled());
                destBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
                destBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
                destBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
                destBand.setSolarFlux(sourceBand.getSolarFlux());
                if (sourceBand.isNoDataValueSet()) {
                    destBand.setNoDataValue(sourceBand.getNoDataValue());
                }
                destBand.setNoDataValueUsed(sourceBand.isNoDataValueUsed());
                destBand.setValidPixelExpression(sourceBand.getValidPixelExpression());
                FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
                IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
                if (sourceFlagCoding != null) {
                    String flagCodingName = sourceFlagCoding.getName();
                    FlagCoding destFlagCoding = product.getFlagCodingGroup().get(flagCodingName);
                    if (destFlagCoding == null) {
                        destFlagCoding = ProductUtils.copyFlagCoding(sourceFlagCoding, product);
                    }
                    destBand.setSampleCoding(destFlagCoding);
                } else if (sourceIndexCoding != null) {
                    String indexCodingName = sourceIndexCoding.getName();
                    IndexCoding destIndexCoding = product.getIndexCodingGroup().get(indexCodingName);
                    if (destIndexCoding == null) {
                        destIndexCoding = ProductUtils.copyIndexCoding(sourceIndexCoding, product);
                    }
                    destBand.setSampleCoding(destIndexCoding);
                } else {
                    destBand.setSampleCoding(null);
                }
                if (this.isFullScene(this.getSubsetDef()) && sourceBand.isStxSet()) {
                    this.copyStx(sourceBand, destBand);
                }
                product.addBand(destBand);
                this.bandMap.put(destBand, sourceBand);
            }
            ++i;
        }
        for (Map.Entry entry : this.bandMap.entrySet()) {
            this.copyImageInfo((RasterDataNode)entry.getValue(), (RasterDataNode)entry.getKey());
        }
    }

    protected void addTiePointGridsToProduct(Product product) {
        String lonGridName;
        String latGridName;
        GeoCoding geoCoding = this.getSourceProduct().getGeoCoding();
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tiePointGeoCoding = (TiePointGeoCoding)geoCoding;
            TiePointGrid latGrid = tiePointGeoCoding.getLatGrid();
            TiePointGrid lonGrid = tiePointGeoCoding.getLonGrid();
            latGridName = latGrid.getName();
            lonGridName = lonGrid.getName();
        } else {
            latGridName = null;
            lonGridName = null;
        }
        int i = 0;
        while (i < this.getSourceProduct().getNumTiePointGrids()) {
            TiePointGrid sourceTiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            String gridName = sourceTiePointGrid.getName();
            if (this.isNodeAccepted(gridName) || gridName.equals(latGridName) || gridName.equals(lonGridName)) {
                TiePointGrid tiePointGrid = TiePointGrid.createSubset(sourceTiePointGrid, this.getSubsetDef());
                if (this.isFullScene(this.getSubsetDef()) && sourceTiePointGrid.isStxSet()) {
                    this.copyStx(sourceTiePointGrid, tiePointGrid);
                }
                product.addTiePointGrid(tiePointGrid);
                this.copyImageInfo(sourceTiePointGrid, tiePointGrid);
            }
            ++i;
        }
    }

    private void copyStx(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        Stx sourceStx = sourceRaster.getStx();
        Histogram sourceHistogram = sourceStx.getHistogram();
        Histogram targetHistogram = new Histogram(sourceStx.getHistogramBinCount(), sourceHistogram.getLowValue(0), sourceHistogram.getHighValue(0), 1);
        System.arraycopy(sourceHistogram.getBins(0), 0, targetHistogram.getBins(0), 0, sourceStx.getHistogramBinCount());
        Stx targetStx = new Stx(sourceStx.getMinimum(), sourceStx.getMaximum(), sourceStx.getMean(), sourceStx.getStandardDeviation(), sourceStx.isLogHistogram(), sourceStx.isIntHistogram(), targetHistogram, sourceStx.getResolutionLevel());
        targetRaster.setStx(targetStx);
    }

    private void copyImageInfo(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        if (sourceRaster.getImageInfo() != null) {
            ImageInfo imageInfo = sourceRaster.getImageInfo().createDeepCopy();
            targetRaster.setImageInfo(imageInfo);
        }
    }

    private boolean isFullScene(ProductSubsetDef subsetDef) {
        if (subsetDef == null) {
            return true;
        }
        Rectangle sourceRegion = new Rectangle(0, 0, this.sourceProduct.getSceneRasterWidth(), this.getSceneRasterHeight());
        return subsetDef.getRegion() == null || subsetDef.getRegion().equals(sourceRegion) && subsetDef.getSubSamplingX() == 1 && subsetDef.getSubSamplingY() == 1;
    }

    protected void addGeoCodingToProduct(Product product) {
        if (!this.getSourceProduct().transferGeoCodingTo(product, this.getSubsetDef())) {
            Debug.trace("GeoCoding could not be transferred.");
        }
    }
}

