/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.math.MathUtils;

public class ColorPaletteDef
implements Cloneable {
    private static final String _PROPERTY_KEY_NUM_POINTS = "numPoints";
    private static final String _PROPERTY_KEY_COLOR = "color";
    private static final String _PROPERTY_KEY_SAMPLE = "sample";
    private static final String _PROPERTY_KEY_AUTODISTRIBUTE = "autoDistribute";
    private Vector<Point> points;
    private int numColors;
    private boolean discrete;
    private boolean autoDistribute;

    public ColorPaletteDef(double minSample, double maxSample) {
        this(minSample, 0.5 * (maxSample + minSample), maxSample);
    }

    public ColorPaletteDef(double minSample, double centerSample, double maxSample) {
        this(new Point[]{new Point(minSample, Color.black), new Point(centerSample, Color.gray), new Point(maxSample, Color.white)}, 256);
    }

    public ColorPaletteDef(Point[] points) {
        this(points, 256);
    }

    public ColorPaletteDef(Point[] points, int numColors) {
        Guardian.assertGreaterThan("numColors", numColors, 1L);
        Guardian.assertNotNull("points", points);
        Guardian.assertGreaterThan("points.length", points.length, 1L);
        this.numColors = numColors;
        this.points = new Vector(points.length);
        this.points.addAll(Arrays.asList(points));
        this.discrete = false;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setNumColors(int numColors) {
        this.numColors = numColors;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public void setNumPoints(int numPoints) {
        while (this.getNumPoints() < numPoints) {
            this.addPoint(new Point(this.getMaxDisplaySample() + 1.0, Color.BLACK));
        }
        while (this.getNumPoints() > numPoints) {
            this.removePointAt(this.getNumPoints() - 1);
        }
    }

    public boolean isAutoDistribute() {
        return this.autoDistribute;
    }

    public void setAutoDistribute(boolean autoDistribute) {
        this.autoDistribute = autoDistribute;
    }

    public Point getPointAt(int index) {
        return this.points.get(index);
    }

    public Point getFirstPoint() {
        return this.points.firstElement();
    }

    public Point getLastPoint() {
        return this.points.lastElement();
    }

    public double getMinDisplaySample() {
        return this.getFirstPoint().getSample();
    }

    public double getMaxDisplaySample() {
        return this.getLastPoint().getSample();
    }

    public void insertPointAfter(int index, Point point) {
        this.points.insertElementAt(point, index + 1);
    }

    public boolean createPointAfter(int index, Scaling scaling) {
        Point point1 = this.getPointAt(index);
        Point point2 = null;
        if (index < this.points.indexOf(this.points.lastElement())) {
            point2 = this.getPointAt(index + 1);
        }
        if (point2 != null) {
            double max = Math.max(point1.getSample(), point2.getSample());
            double min = Math.min(point1.getSample(), point2.getSample());
            double middle = scaling.scale(0.5 * (scaling.scaleInverse(min) + scaling.scaleInverse(max)));
            Point newPoint = new Point(middle, ColorPaletteDef.getCenterColor(point1.getColor(), point2.getColor()));
            this.insertPointAfter(index, newPoint);
            return true;
        }
        return false;
    }

    public static Color getCenterColor(Color c1, Color c2) {
        return new Color(0.5f * (float)(c1.getRed() + c2.getRed()) / 255.0f, 0.5f * (float)(c1.getGreen() + c2.getGreen()) / 255.0f, 0.5f * (float)(c1.getBlue() + c2.getBlue()) / 255.0f, 0.5f * (float)(c1.getAlpha() + c2.getAlpha()) / 255.0f);
    }

    public void removePointAt(int index) {
        this.check2PointsMinimum();
        this.points.remove(index);
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public Point[] getPoints() {
        Point[] points = new Point[this.getNumPoints()];
        int i = 0;
        while (i < this.getNumPoints()) {
            points[i] = this.getPointAt(i);
            ++i;
        }
        return points;
    }

    public void setPoints(Point[] points) {
        Assert.notNull(points);
        Assert.argument(points.length >= 2, "points.length >= 2");
        this.points.clear();
        this.points.addAll(Arrays.asList(points));
    }

    public Iterator getIterator() {
        return this.points.iterator();
    }

    public final Object clone() {
        try {
            ColorPaletteDef def = (ColorPaletteDef)super.clone();
            Vector<Point> pointVector = new Vector<Point>();
            pointVector.setSize(this.points.size());
            int i = 0;
            while (i < this.points.size()) {
                Point point = this.points.get(i);
                pointVector.set(i, point.createClone());
                ++i;
            }
            def.points = pointVector;
            def.numColors = this.numColors;
            def.discrete = this.discrete;
            def.autoDistribute = this.autoDistribute;
            return def;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ColorPaletteDef createDeepCopy() {
        return (ColorPaletteDef)this.clone();
    }

    public static ColorPaletteDef loadColorPaletteDef(File file) throws IOException {
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.load(file);
        int numPoints = propertyMap.getPropertyInt(_PROPERTY_KEY_NUM_POINTS);
        if (numPoints < 2) {
            throw new IOException("The selected file contains less than\ntwo colour points.");
        }
        Point[] points = new Point[numPoints];
        double lastSample = 0.0;
        int i = 0;
        while (i < points.length) {
            Point point = new Point();
            Color color = propertyMap.getPropertyColor(_PROPERTY_KEY_COLOR + i);
            double sample = propertyMap.getPropertyDouble(_PROPERTY_KEY_SAMPLE + i);
            if (i > 0 && sample < lastSample) {
                sample = lastSample + 1.0;
            }
            point.setColor(color);
            point.setSample(sample);
            points[i] = point;
            lastSample = sample;
            ++i;
        }
        ColorPaletteDef paletteDef = new ColorPaletteDef(points, 256);
        paletteDef.setAutoDistribute(propertyMap.getPropertyBool(_PROPERTY_KEY_AUTODISTRIBUTE, false));
        return paletteDef;
    }

    public static void storeColorPaletteDef(ColorPaletteDef colorPaletteDef, File file) throws IOException {
        Point[] points = colorPaletteDef.getPoints();
        PropertyMap propertyMap = new PropertyMap();
        int numPoints = points.length;
        propertyMap.setPropertyInt(_PROPERTY_KEY_NUM_POINTS, numPoints);
        propertyMap.setPropertyBool(_PROPERTY_KEY_AUTODISTRIBUTE, colorPaletteDef.isAutoDistribute());
        int i = 0;
        while (i < numPoints) {
            propertyMap.setPropertyColor(_PROPERTY_KEY_COLOR + i, points[i].getColor());
            propertyMap.setPropertyDouble(_PROPERTY_KEY_SAMPLE + i, points[i].getSample());
            ++i;
        }
        propertyMap.store(file, "BEAM Colour Palette Definition File");
    }

    private void check2PointsMinimum() {
        if (this.getNumPoints() == 2) {
            throw new IllegalStateException("gradation curve must at least have 2 points");
        }
    }

    public void dispose() {
        if (this.points != null) {
            this.points.removeAllElements();
            this.points = null;
        }
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            colors[i] = this.points.get(i).getColor();
            ++i;
        }
        return colors;
    }

    @Deprecated
    public Color[] createColorPalette(Scaling scaling) {
        Color[] colorPalette = new Color[this.numColors];
        double displayMin = this.getMinDisplaySample();
        double displayMax = this.getMaxDisplaySample();
        double scalingFactor = 1.0 / ((double)this.numColors - 1.0);
        int i = 0;
        while (i < this.numColors) {
            double w = (double)i * scalingFactor;
            double sample = displayMin + w * (displayMax - displayMin);
            colorPalette[i] = this.computeColor(sample, displayMin, displayMax);
            ++i;
        }
        return colorPalette;
    }

    public Color computeColor(Scaling scaling, double sample) {
        return this.computeColor(sample, this.getMinDisplaySample(), this.getMaxDisplaySample());
    }

    private Color computeColor(double sample, double minDisplay, double maxDisplay) {
        Color c = sample <= minDisplay ? this.getFirstPoint().getColor() : (sample >= maxDisplay ? this.getLastPoint().getColor() : this.computeColor(sample));
        return c;
    }

    private Color computeColor(double sample) {
        int i = 0;
        while (i < this.getNumPoints() - 1) {
            Point p1 = this.getPointAt(i);
            Point p2 = this.getPointAt(i + 1);
            double sample1 = p1.getSample();
            double sample2 = p2.getSample();
            Color color1 = p1.getColor();
            Color color2 = p2.getColor();
            if (sample >= sample1 && sample <= sample2) {
                if (this.discrete) {
                    return color1;
                }
                return this.computeColor(sample, sample1, sample2, color1, color2);
            }
            ++i;
        }
        return Color.BLACK;
    }

    private Color computeColor(double sample, double sample1, double sample2, Color color1, Color color2) {
        double f = (sample - sample1) / (sample2 - sample1);
        double r1 = color1.getRed();
        double r2 = color2.getRed();
        double g1 = color1.getGreen();
        double g2 = color2.getGreen();
        double b1 = color1.getBlue();
        double b2 = color2.getBlue();
        double a1 = color1.getAlpha();
        double a2 = color2.getAlpha();
        int red = (int)MathUtils.roundAndCrop(r1 + f * (r2 - r1), 0L, 255L);
        int green = (int)MathUtils.roundAndCrop(g1 + f * (g2 - g1), 0L, 255L);
        int blue = (int)MathUtils.roundAndCrop(b1 + f * (b2 - b1), 0L, 255L);
        int alpha = (int)MathUtils.roundAndCrop(a1 + f * (a2 - a1), 0L, 255L);
        return new Color(red, green, blue, alpha);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorPaletteDef that = (ColorPaletteDef)o;
        if (this.autoDistribute != that.autoDistribute) {
            return false;
        }
        if (this.discrete != that.discrete) {
            return false;
        }
        if (this.numColors != that.numColors) {
            return false;
        }
        return this.points.equals(that.points);
    }

    public int hashCode() {
        int result = this.points.hashCode();
        result = 31 * result + this.numColors;
        result = 31 * result + (this.discrete ? 1 : 0);
        result = 31 * result + (this.autoDistribute ? 1 : 0);
        return result;
    }

    public static class Point
    implements Cloneable {
        private double sample;
        private Color color;
        private String label;

        public Point() {
            this(0.0, Color.black);
        }

        public Point(double sample, Color color) {
            this(sample, color, "");
        }

        public Point(double sample, Color color, String label) {
            this.sample = sample;
            this.color = color;
            this.label = label;
        }

        public double getSample() {
            return this.sample;
        }

        public void setSample(double sample) {
            this.sample = sample;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public final Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Point createClone() {
            return (Point)this.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (Double.compare(point.sample, this.sample) != 0) {
                return false;
            }
            if (this.color != null ? !this.color.equals(point.color) : point.color != null) {
                return false;
            }
            return !(this.label != null ? !this.label.equals(point.label) : point.label != null);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.sample);
            int result = (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

