/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.util.Guardian;

public class SampleCoding
extends MetadataElement {
    public SampleCoding(String name) {
        super(name);
    }

    @Override
    public void addElement(MetadataElement element) {
    }

    @Override
    public void addAttribute(MetadataAttribute attribute) {
        if (!attribute.getData().isInt()) {
            throw new IllegalArgumentException("attribute value is not a integer");
        }
        if (!attribute.getData().isScalar()) {
            throw new IllegalArgumentException("attribute value is not a scalar");
        }
        super.addAttribute(attribute);
    }

    public MetadataAttribute addSample(String name, int value, String description) {
        Guardian.assertNotNull("name", name);
        MetadataAttribute attribute = new MetadataAttribute(name, 12);
        attribute.setDataElems(new int[]{value});
        if (description != null) {
            attribute.setDescription(description);
        }
        this.addAttribute(attribute);
        return attribute;
    }

    public int getSampleCount() {
        return this.getNumAttributes();
    }

    public String getSampleName(int index) {
        return this.getAttributeAt(index).getName();
    }

    public int getSampleValue(int index) {
        return this.getAttributeAt(index).getData().getElemInt();
    }
}

