/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;

public final class SceneFactory {
    public static Scene createScene(ProductNode node) {
        if (node instanceof Product) {
            Product product = (Product)node;
            return new ProductScene(product);
        }
        if (node instanceof RasterDataNode) {
            RasterDataNode raster = (RasterDataNode)node;
            return new RasterDataNodeScene(raster);
        }
        return null;
    }

    private static boolean transferGeoCoding(Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) {
        GeoCoding sourceGeoCoding = sourceScene.getGeoCoding();
        if (sourceGeoCoding == null) {
            targetScene.setGeoCoding(null);
            return true;
        }
        if (sourceGeoCoding instanceof AbstractGeoCoding) {
            AbstractGeoCoding abstractGeoCoding = (AbstractGeoCoding)sourceGeoCoding;
            return abstractGeoCoding.transferGeoCoding(sourceScene, targetScene, subsetDef);
        }
        return false;
    }

    private static boolean transferGeoCodingBandwise(Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) {
        String[] rasterNames = StringUtils.addArrays(sourceScene.getProduct().getBandNames(), sourceScene.getProduct().getTiePointGridNames());
        int numTransferred = 0;
        String[] stringArray = rasterNames;
        int n = rasterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String rasterName = stringArray[n2];
            RasterDataNode sourceRaster = sourceScene.getProduct().getRasterDataNode(rasterName);
            if (sourceRaster != null) {
                Scene sourceRasterScene = SceneFactory.createScene(sourceRaster);
                RasterDataNode targetRaster = targetScene.getProduct().getRasterDataNode(rasterName);
                if (targetRaster != null) {
                    Scene targetRasterScene = SceneFactory.createScene(targetRaster);
                    if (SceneFactory.transferGeoCoding(sourceRasterScene, targetRasterScene, subsetDef)) {
                        ++numTransferred;
                    } else {
                        BeamLogManager.getSystemLogger().warning("failed to transfer geo-coding of band '" + sourceRaster.getName() + "'");
                    }
                }
            }
            ++n2;
        }
        if (numTransferred == 0) {
            return SceneFactory.transferGeoCoding(sourceScene, targetScene, subsetDef);
        }
        return numTransferred > 0;
    }

    private static class ProductScene
    implements Scene {
        private final Product product;

        public ProductScene(Product product) {
            Guardian.assertNotNull("product", product);
            this.product = product;
        }

        @Override
        public void setGeoCoding(GeoCoding geoCoding) {
            this.product.setGeoCoding(geoCoding);
        }

        @Override
        public GeoCoding getGeoCoding() {
            return this.product.getGeoCoding();
        }

        @Override
        public boolean transferGeoCodingTo(Scene targetScene, ProductSubsetDef subsetDef) {
            if (this.product.isUsingSingleGeoCoding()) {
                return SceneFactory.transferGeoCoding(this, targetScene, subsetDef);
            }
            return SceneFactory.transferGeoCodingBandwise(this, targetScene, subsetDef);
        }

        @Override
        public int getRasterWidth() {
            return this.product.getSceneRasterWidth();
        }

        @Override
        public int getRasterHeight() {
            return this.product.getSceneRasterHeight();
        }

        @Override
        public Product getProduct() {
            return this.product;
        }
    }

    private static class RasterDataNodeScene
    implements Scene {
        RasterDataNode raster;

        public RasterDataNodeScene(RasterDataNode raster) {
            Guardian.assertNotNull("raster", raster);
            this.raster = raster;
        }

        @Override
        public GeoCoding getGeoCoding() {
            return this.raster.getGeoCoding();
        }

        @Override
        public void setGeoCoding(GeoCoding geoCoding) {
            this.raster.setGeoCoding(geoCoding);
        }

        @Override
        public boolean transferGeoCodingTo(Scene destScene, ProductSubsetDef subsetDef) {
            return SceneFactory.transferGeoCoding(this, destScene, subsetDef);
        }

        @Override
        public int getRasterWidth() {
            return this.raster.getSceneRasterWidth();
        }

        @Override
        public int getRasterHeight() {
            return this.raster.getSceneRasterHeight();
        }

        @Override
        public Product getProduct() {
            return this.raster.getProduct();
        }
    }
}

