/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.barithm;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Function;
import com.bc.jexp.ParseException;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.WritableNamespace;
import com.bc.jexp.impl.AbstractSymbol;
import com.bc.jexp.impl.DefaultNamespace;
import com.bc.jexp.impl.NamespaceImpl;
import com.bc.jexp.impl.ParserImpl;
import com.bc.jexp.impl.Tokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.barithm.MoreFuncs;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataLoop;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.framework.dataop.barithm.SingleFlagSymbol;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;

public class BandArithmetic {
    public static final String PIXEL_X_NAME = "X";
    public static final String PIXEL_Y_NAME = "Y";
    private static final Symbol PIXEL_X_SYMBOL = new AbstractSymbol.D("X"){

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return (double)((RasterDataEvalEnv)env).getPixelX() + 0.5;
        }
    };
    private static final Symbol PIXEL_Y_SYMBOL = new AbstractSymbol.D("Y"){

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return (double)((RasterDataEvalEnv)env).getPixelY() + 0.5;
        }
    };
    private static final WritableNamespace DEFAULT_NAMESPACE = new DefaultNamespace();
    private static final List<NamespaceExtender> _namespaceExtenderList = new ArrayList<NamespaceExtender>();

    static {
        MoreFuncs.registerExtraFunctions();
        MoreFuncs.registerExtraSymbols();
    }

    private BandArithmetic() {
    }

    public static void addNamespaceExtender(NamespaceExtender ne) {
        if (ne != null && !_namespaceExtenderList.contains(ne)) {
            _namespaceExtenderList.add(ne);
        }
    }

    public static void removeNamespaceExtender(NamespaceExtender ne) {
        _namespaceExtenderList.remove(ne);
    }

    public static void registerSymbol(Symbol s) {
        DEFAULT_NAMESPACE.registerSymbol(s);
    }

    public static void deregisterSymbol(Symbol s) {
        DEFAULT_NAMESPACE.deregisterSymbol(s);
    }

    public static void registerFunction(Function f) {
        DEFAULT_NAMESPACE.registerFunction(f);
    }

    public static void deregisterFunction(Function f) {
        DEFAULT_NAMESPACE.deregisterFunction(f);
    }

    public static Term parseExpression(String expression, Product[] products, int defaultProductIndex) throws ParseException {
        Assert.notNull(expression, null);
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace(products, defaultProductIndex);
        ParserImpl parser = new ParserImpl(namespace, false);
        return parser.parse(expression);
    }

    public static WritableNamespace createDefaultNamespace(Product[] products, int defaultProductIndex) {
        return BandArithmetic.createDefaultNamespace(products, defaultProductIndex, new ProductPrefixProvider(){

            @Override
            public String getPrefix(Product product) {
                return BandArithmetic.getProductNodeNamePrefix(product);
            }
        });
    }

    public static WritableNamespace createDefaultNamespace(Product[] products, int defaultProductIndex, ProductPrefixProvider prefixProvider) {
        Guardian.assertNotNullOrEmpty("products", products);
        Guardian.assertWithinRange("defaultProductIndex", defaultProductIndex, 0L, products.length);
        NamespaceImpl namespace = new NamespaceImpl(DEFAULT_NAMESPACE);
        BandArithmetic.registerProductSymbols(namespace, products[defaultProductIndex], "");
        if (products.length > 1) {
            Product[] productArray = products;
            int n = products.length;
            int n2 = 0;
            while (n2 < n) {
                Product product = productArray[n2];
                BandArithmetic.registerProductSymbols(namespace, product, prefixProvider.getPrefix(product));
                ++n2;
            }
        }
        namespace.registerSymbol(PIXEL_X_SYMBOL);
        namespace.registerSymbol(PIXEL_Y_SYMBOL);
        return namespace;
    }

    @Deprecated
    public static int computeBand(String expression, String validMaskExpression, Product[] sourceProducts, int defaultProductIndex, boolean checkInvalids, boolean noDataValueUsed, double noDataValue, int offsetX, int offsetY, int width, int height, ProductData targetRasterData, Scaling scaling, ProgressMonitor pm) throws ParseException, IOException {
        Term term = BandArithmetic.parseExpression(expression, sourceProducts, defaultProductIndex);
        Term validMaskTerm = validMaskExpression != null && !validMaskExpression.trim().isEmpty() ? BandArithmetic.parseExpression(validMaskExpression, sourceProducts, defaultProductIndex) : null;
        return BandArithmetic.computeBand(term, validMaskTerm, checkInvalids, noDataValueUsed, noDataValue, offsetX, offsetY, width, height, targetRasterData, scaling, pm);
    }

    @Deprecated
    public static int computeBand(final Term term, final Term validMaskTerm, boolean checkInvalids, final boolean noDataValueUsed, final double noDataValue, int offsetX, int offsetY, int width, int height, final ProductData targetRasterData, final Scaling scaling, ProgressMonitor pm) throws IOException {
        Term[] termArray;
        final boolean performInvalidCheck = checkInvalids || noDataValueUsed;
        final int[] numInvalidPixels = new int[1];
        if (validMaskTerm != null) {
            Term[] termArray2 = new Term[2];
            termArray2[0] = term;
            termArray = termArray2;
            termArray2[1] = validMaskTerm;
        } else {
            Term[] termArray3 = new Term[1];
            termArray = termArray3;
            termArray3[0] = term;
        }
        RasterDataLoop loop = new RasterDataLoop(offsetX, offsetY, width, height, termArray, pm);
        loop.forEachPixel(new RasterDataLoop.Body(){

            @Override
            public void eval(RasterDataEvalEnv env, int pixelIndex) {
                double pixelValue = term.evalD(env);
                if (performInvalidCheck && (validMaskTerm != null && validMaskTerm.evalD(env) == 0.0 || BandArithmetic.isInvalidValue(pixelValue))) {
                    numInvalidPixels[0] = numInvalidPixels[0] + 1;
                    if (noDataValueUsed) {
                        pixelValue = noDataValue;
                    }
                }
                if (scaling != null) {
                    targetRasterData.setElemDoubleAt(pixelIndex, scaling.scaleInverse(pixelValue));
                } else {
                    targetRasterData.setElemDoubleAt(pixelIndex, pixelValue);
                }
            }
        }, "Performing band math...");
        return numInvalidPixels[0];
    }

    public static String getValidMaskExpression(String expression, Product[] products, int defaultProductIndex, String validMaskExpression) throws ParseException {
        Assert.notNull(expression, "expression");
        Assert.notNull(products, "products");
        Assert.argument(products.length > 0, "products");
        Assert.argument(defaultProductIndex >= 0 && defaultProductIndex < products.length, "defaultProductIndex");
        RasterDataNode[] rasters = BandArithmetic.getRefRasters(expression, products, defaultProductIndex);
        if (rasters.length == 0) {
            return validMaskExpression;
        }
        Product contextProduct = products[defaultProductIndex];
        if (StringUtils.isNullOrEmpty(validMaskExpression) && rasters.length == 1 && contextProduct == rasters[0].getProduct()) {
            return rasters[0].getValidMaskExpression();
        }
        ArrayList<String> vmes = new ArrayList<String>(rasters.length);
        RasterDataNode[] rasterDataNodeArray = rasters;
        int n = rasters.length;
        int n2 = 0;
        while (n2 < n) {
            RasterDataNode raster = rasterDataNodeArray[n2];
            String vme = raster.getValidMaskExpression();
            if (vme != null) {
                if (raster.getProduct() != contextProduct) {
                    int productIndex = BandArithmetic.getProductIndex(products, raster);
                    Assert.state(productIndex >= 0, "productIndex >= 0");
                    vme = BandArithmetic.createUnambiguousExpression(vme, products, productIndex);
                }
                if (!vmes.contains(vme)) {
                    vmes.add(vme);
                }
            }
            ++n2;
        }
        if (vmes.isEmpty()) {
            return validMaskExpression;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotNullAndNotEmpty(validMaskExpression)) {
            sb.append("(");
            sb.append(validMaskExpression);
            sb.append(")");
        }
        for (String vme : vmes) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append("(");
            sb.append(vme);
            sb.append(")");
        }
        return sb.toString();
    }

    private static String createUnambiguousExpression(String vme, Product[] products, int productIndex) throws ParseException {
        RasterDataNode[] rasters;
        RasterDataNode[] rasterDataNodeArray = rasters = BandArithmetic.getRefRasters(vme, products, productIndex);
        int n = rasters.length;
        int n2 = 0;
        while (n2 < n) {
            boolean changed;
            RasterDataNode raster = rasterDataNodeArray[n2];
            String name = raster.getName();
            int namePos = 0;
            do {
                char c2;
                changed = false;
                if ((namePos = vme.indexOf(name, namePos)) == 0) {
                    String prefix = BandArithmetic.getProductNodeNamePrefix(raster.getProduct());
                    vme = String.valueOf(prefix) + vme;
                    namePos += name.length() + prefix.length();
                    changed = true;
                    continue;
                }
                if (namePos <= 0) continue;
                int i1 = namePos - 1;
                int i2 = namePos + name.length();
                char c1 = vme.charAt(i1);
                char c = c2 = i2 < vme.length() ? vme.charAt(i2) : (char)'\u0000';
                if (c1 == '.' || BandArithmetic.isNameChar(c1) || BandArithmetic.isNameChar(c2)) continue;
                String prefix = BandArithmetic.getProductNodeNamePrefix(raster.getProduct());
                vme = String.valueOf(vme.substring(0, namePos)) + prefix + vme.substring(namePos);
                namePos += name.length() + prefix.length();
                changed = true;
            } while (changed);
            ++n2;
        }
        return vme;
    }

    private static boolean isNameChar(char c) {
        return Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c);
    }

    private static int getProductIndex(Product[] products, RasterDataNode raster) {
        int productIndex = -1;
        int i = 0;
        while (i < products.length) {
            Product product = products[i];
            if (product == raster.getProduct()) {
                productIndex = i;
                break;
            }
            ++i;
        }
        return productIndex;
    }

    public static RasterDataNode[] getRefRasters(String expression, Product ... products) throws ParseException {
        return BandArithmetic.getRefRasters(expression, products, 0);
    }

    public static RasterDataNode[] getRefRasters(String expression, Product[] products, int defaultProductNamePrefix) throws ParseException {
        RasterDataSymbol[] symbols = BandArithmetic.getRefRasterDataSymbols(new Term[]{BandArithmetic.parseExpression(expression, products, defaultProductNamePrefix)});
        RasterDataNode[] rasters = new RasterDataNode[symbols.length];
        int i = 0;
        while (i < symbols.length) {
            rasters[i] = symbols[i].getRaster();
            ++i;
        }
        return rasters;
    }

    public static RasterDataNode[] getRefRasters(RasterDataSymbol[] rasterDataSymbols) {
        HashSet<RasterDataNode> set = new HashSet<RasterDataNode>(rasterDataSymbols.length * 2);
        ArrayList<RasterDataNode> list = new ArrayList<RasterDataNode>(rasterDataSymbols.length);
        RasterDataSymbol[] rasterDataSymbolArray = rasterDataSymbols;
        int n = rasterDataSymbols.length;
        int n2 = 0;
        while (n2 < n) {
            RasterDataSymbol symbol = rasterDataSymbolArray[n2];
            RasterDataNode raster = symbol.getRaster();
            if (!set.contains(raster)) {
                list.add(raster);
                set.add(raster);
            }
            ++n2;
        }
        return list.toArray(new RasterDataNode[list.size()]);
    }

    public static RasterDataSymbol[] getRefRasterDataSymbols(Term term) {
        return BandArithmetic.getRefRasterDataSymbols(new Term[]{term});
    }

    public static RasterDataSymbol[] getRefRasterDataSymbols(Term[] terms) {
        ArrayList<RasterDataSymbol> list = new ArrayList<RasterDataSymbol>();
        HashSet<RasterDataSymbol> set = new HashSet<RasterDataSymbol>();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term != null) {
                BandArithmetic.collectRefRasterDataSymbols(term, list, set);
            }
            ++n2;
        }
        return list.toArray(new RasterDataSymbol[list.size()]);
    }

    public static String createExternalName(String name) {
        return Tokenizer.createExternalName(name);
    }

    public static String getProductNodeNamePrefix(Product product) {
        Guardian.assertNotNull("product", product);
        return "$" + product.getRefNo() + '.';
    }

    private static void registerProductSymbols(WritableNamespace namespace, Product product, String namePrefix) {
        BandArithmetic.registerTiePointGridSymbols(namespace, product, namePrefix);
        BandArithmetic.registerBandSymbols(namespace, product, namePrefix);
        BandArithmetic.registerMaskSymbols(namespace, product, namePrefix);
        BandArithmetic.registerSingleFlagSymbols(namespace, product, namePrefix);
        BandArithmetic.informNamespaceExtenders(namespace, product, namePrefix);
    }

    private static void registerTiePointGridSymbols(WritableNamespace namespace, Product product, String namePrefix) {
        int i = 0;
        while (i < product.getNumTiePointGrids()) {
            TiePointGrid grid = product.getTiePointGridAt(i);
            String symbolName = String.valueOf(namePrefix) + grid.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, grid, RasterDataSymbol.GEOPHYSICAL));
            ++i;
        }
    }

    private static void registerBandSymbols(WritableNamespace namespace, Product product, String namePrefix) {
        int i = 0;
        while (i < product.getNumBands()) {
            Band band = product.getBandAt(i);
            String symbolName = String.valueOf(namePrefix) + band.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, band, RasterDataSymbol.GEOPHYSICAL));
            namespace.registerSymbol(new RasterDataSymbol(String.valueOf(symbolName) + ".raw", band, RasterDataSymbol.RAW));
            ++i;
        }
    }

    private static void registerMaskSymbols(WritableNamespace namespace, Product product, String namePrefix) {
        int i = 0;
        while (i < product.getMaskGroup().getNodeCount()) {
            Mask mask = product.getMaskGroup().get(i);
            String symbolName = String.valueOf(namePrefix) + mask.getName();
            namespace.registerSymbol(new RasterDataSymbol(symbolName, mask));
            ++i;
        }
    }

    private static void registerSingleFlagSymbols(WritableNamespace namespace, Product product, String namePrefix) {
        int i = 0;
        while (i < product.getNumBands()) {
            Band band = product.getBandAt(i);
            if (band.getFlagCoding() != null) {
                int j = 0;
                while (j < band.getFlagCoding().getNumAttributes()) {
                    MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                    int flagMask = attribute.getData().getElemInt();
                    String symbolName = String.valueOf(namePrefix) + band.getName() + "." + attribute.getName();
                    SingleFlagSymbol symbol = new SingleFlagSymbol(symbolName, (RasterDataNode)band, flagMask);
                    namespace.registerSymbol(symbol);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void informNamespaceExtenders(WritableNamespace namespace, Product product, String namePrefix) {
        Iterator<NamespaceExtender> iterator = _namespaceExtenderList.iterator();
        while (iterator.hasNext()) {
            NamespaceExtender a_namespaceExtenderList;
            NamespaceExtender namespaceExtender = a_namespaceExtenderList = iterator.next();
            namespaceExtender.extendNamespace(namespace, product, namePrefix);
        }
    }

    private static void collectRefRasterDataSymbols(Term term, List<RasterDataSymbol> list, Set<RasterDataSymbol> set) {
        if (term == null) {
            return;
        }
        if (term instanceof Term.Ref) {
            RasterDataSymbol rds;
            Symbol symbol = ((Term.Ref)term).getSymbol();
            if (symbol instanceof RasterDataSymbol && !set.contains(rds = (RasterDataSymbol)symbol)) {
                list.add(rds);
                set.add(rds);
            }
        } else {
            Term[] children;
            Term[] termArray = children = term.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Term child = termArray[n2];
                BandArithmetic.collectRefRasterDataSymbols(child, list, set);
                ++n2;
            }
        }
    }

    private static boolean isInvalidValue(double pixelValue) {
        return Double.isNaN(pixelValue) || Double.isInfinite(pixelValue);
    }

    public static interface NamespaceExtender {
        public void extendNamespace(WritableNamespace var1, Product var2, String var3);
    }

    public static interface ProductPrefixProvider {
        public String getPrefix(Product var1);
    }
}

