/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.geom.AffineTransform;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.util.Guardian;

@Deprecated
public class MapInfo
implements Cloneable {
    public static final double DEFAULT_NO_DATA_VALUE = 9999.0;
    private float _pixelX;
    private float _pixelY;
    private MapProjection _mapProjection;
    private Datum _datum;
    private float _easting;
    private float _northing;
    private float _pixelSizeX;
    private float _pixelSizeY;
    private float _orientation;
    private int _sceneWidth;
    private int _sceneHeight;
    private boolean _sceneSizeFitted;
    private boolean _orthorectified;
    private double _noDataValue;
    private String _elevationModelName;
    private Resampling _resampling;

    public MapInfo(MapProjection mapProjection, float pixelX, float pixelY, float easting, float northing, float pixelSizeX, float pixelSizeY, Datum datum) {
        Guardian.assertNotNull("mapProjection", mapProjection);
        Guardian.assertNotNull("datum", datum);
        this._mapProjection = mapProjection;
        this._pixelX = pixelX;
        this._pixelY = pixelY;
        this._easting = easting;
        this._northing = northing;
        this._pixelSizeX = pixelSizeX;
        this._pixelSizeY = pixelSizeY;
        this._datum = datum;
        this._sceneSizeFitted = false;
        this._noDataValue = 9999.0;
        this._elevationModelName = null;
        this._resampling = Resampling.NEAREST_NEIGHBOUR;
        this.alterMapTransform();
    }

    private void alterMapTransform() {
        this._mapProjection.alterMapTransform(this._datum.getEllipsoid());
    }

    public final MapProjection getMapProjection() {
        return this._mapProjection;
    }

    public final void setProjection(MapProjection projection) {
        this._mapProjection = projection;
    }

    public final float getPixelX() {
        return this._pixelX;
    }

    public final void setPixelX(float pixelX) {
        this._pixelX = pixelX;
    }

    public final float getPixelY() {
        return this._pixelY;
    }

    public final void setPixelY(float pixelY) {
        this._pixelY = pixelY;
    }

    public final float getEasting() {
        return this._easting;
    }

    public final void setEasting(float easting) {
        this._easting = easting;
    }

    public float getNorthing() {
        return this._northing;
    }

    public final void setNorthing(float northing) {
        this._northing = northing;
    }

    public final float getPixelSizeX() {
        return this._pixelSizeX;
    }

    public final void setPixelSizeX(float pixelSizeX) {
        this._pixelSizeX = pixelSizeX;
    }

    public final float getPixelSizeY() {
        return this._pixelSizeY;
    }

    public final void setPixelSizeY(float pixelSizeY) {
        this._pixelSizeY = pixelSizeY;
    }

    public float getOrientation() {
        return this._orientation;
    }

    public void setOrientation(float orientation) {
        this._orientation = orientation;
    }

    public final Datum getDatum() {
        return this._datum;
    }

    public final void setDatum(Datum datum) {
        this._datum = datum;
    }

    public final int getSceneWidth() {
        return this._sceneWidth;
    }

    public final void setSceneWidth(int sceneWidth) {
        this._sceneWidth = sceneWidth;
    }

    public final int getSceneHeight() {
        return this._sceneHeight;
    }

    public final void setSceneHeight(int sceneHeight) {
        this._sceneHeight = sceneHeight;
    }

    public final boolean isSceneSizeFitted() {
        return this._sceneSizeFitted;
    }

    public final void setSceneSizeFitted(boolean sceneSizeFitted) {
        this._sceneSizeFitted = sceneSizeFitted;
    }

    public final double getNoDataValue() {
        return this._noDataValue;
    }

    public final void setNoDataValue(double noDataValue) {
        this._noDataValue = noDataValue;
    }

    public final boolean isOrthorectified() {
        return this._orthorectified;
    }

    public final void setOrthorectified(boolean orthorectified) {
        this._orthorectified = orthorectified;
    }

    public final String getElevationModelName() {
        return this._elevationModelName;
    }

    public final void setElevationModelName(String elevationModelName) {
        this._elevationModelName = elevationModelName;
    }

    public final Resampling getResampling() {
        return this._resampling;
    }

    public final void setResampling(Resampling resampling) {
        this._resampling = resampling;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getMapProjection().getName());
        buffer.append(", ");
        buffer.append(this.getPixelX());
        buffer.append(", ");
        buffer.append(this.getPixelY());
        buffer.append(", ");
        buffer.append(this.getEasting());
        buffer.append(", ");
        buffer.append(this.getNorthing());
        buffer.append(", ");
        buffer.append(this.getPixelSizeX());
        buffer.append(", ");
        buffer.append(this.getPixelSizeY());
        buffer.append(", ");
        buffer.append(this.getDatum().getName());
        buffer.append(", ");
        buffer.append("units=" + this.getMapProjection().getMapUnit());
        buffer.append(", ");
        buffer.append(this.getSceneWidth());
        buffer.append(", ");
        buffer.append(this.getSceneHeight());
        return buffer.toString();
    }

    public Object clone() {
        try {
            MapInfo mapInfo = (MapInfo)super.clone();
            MapProjection mapProjection = mapInfo.getMapProjection();
            mapInfo.setProjection((MapProjection)mapProjection.clone());
            return mapInfo;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public MapInfo createDeepClone() {
        return (MapInfo)this.clone();
    }

    public AffineTransform getPixelToMapTransform() {
        AffineTransform transform = new AffineTransform();
        transform.translate(this.getEasting(), this.getNorthing());
        transform.scale(this.getPixelSizeX(), -this.getPixelSizeY());
        transform.rotate(Math.toRadians(-this.getOrientation()));
        transform.translate(-this.getPixelX(), -this.getPixelY());
        return transform;
    }
}

