/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.resamp;

import org.esa.beam.framework.dataop.resamp.Resampling;

final class BiCubicInterpolationResampling
implements Resampling {
    private static final float[][] invA = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {2.0f, -2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, -2.0f, -1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, -2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f}, {-3.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -3.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, -1.0f, 0.0f}, {9.0f, -9.0f, -9.0f, 9.0f, 6.0f, 3.0f, -6.0f, -3.0f, 6.0f, -6.0f, 3.0f, -3.0f, 4.0f, 2.0f, 2.0f, 1.0f}, {-6.0f, 6.0f, 6.0f, -6.0f, -3.0f, -3.0f, 3.0f, 3.0f, -4.0f, 4.0f, -2.0f, 2.0f, -2.0f, -2.0f, -1.0f, -1.0f}, {2.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f}, {-6.0f, 6.0f, 6.0f, -6.0f, -4.0f, -2.0f, 4.0f, 2.0f, -3.0f, 3.0f, -3.0f, 3.0f, -2.0f, -1.0f, -2.0f, -1.0f}, {4.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, -2.0f, 2.0f, -2.0f, 1.0f, 1.0f, 1.0f, 1.0f}};

    BiCubicInterpolationResampling() {
    }

    @Override
    public String getName() {
        return "BICUBIC_INTERPOLATION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(2, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        int j1;
        int i1;
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        double di = x - ((double)i0 + 0.5);
        double dj = y - ((double)j0 + 0.5);
        index.i0 = i0;
        index.j0 = j0;
        int iMax = width - 1;
        int jMax = height - 1;
        if (di >= 0.0) {
            i1 = i0 + 1;
            index.i[0] = i0 < 0 ? 0 : (i0 > iMax ? iMax : i0);
            index.i[1] = i1 < 0 ? 0 : (i1 > iMax ? iMax : i1);
            index.ki[0] = di;
        } else {
            i1 = i0 - 1;
            index.i[0] = i1 < 0 ? 0 : (i1 > iMax ? iMax : i1);
            index.i[1] = i0 < 0 ? 0 : (i0 > iMax ? iMax : i0);
            index.ki[0] = di + 1.0;
        }
        if (dj >= 0.0) {
            j1 = j0 + 1;
            index.j[0] = j0 < 0 ? 0 : (j0 > jMax ? jMax : j0);
            index.j[1] = j1 < 0 ? 0 : (j1 > jMax ? jMax : j1);
            index.kj[0] = dj;
        } else {
            j1 = j0 - 1;
            index.j[0] = j1 < 0 ? 0 : (j1 > jMax ? jMax : j1);
            index.j[1] = j0 < 0 ? 0 : (j0 > jMax ? jMax : j0);
            index.kj[0] = dj + 1.0;
        }
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[4];
        int[] y = new int[4];
        double[][] samples = new double[4][4];
        int i = 0;
        while (i < 4) {
            x[i] = (int)Resampling.Index.crop(index.i[0] - 1.0 + (double)i, index.width - 1);
            y[i] = (int)Resampling.Index.crop(index.j[0] - 1.0 + (double)i, index.height - 1);
            ++i;
        }
        if (!raster.getSamples(x, y, samples)) {
            if (Double.isNaN(samples[1][1])) {
                return samples[1][1];
            }
            BiCubicInterpolationResampling.replaceNaNWithMean(samples);
        }
        double[] z = new double[4];
        double[] z1 = new double[4];
        double[] z2 = new double[4];
        double[] z12 = new double[4];
        z[0] = samples[1][1];
        z[1] = samples[1][2];
        z[2] = samples[2][1];
        z[3] = samples[2][2];
        z1[0] = (samples[1][2] - samples[1][0]) / 2.0;
        z1[1] = (samples[1][3] - samples[1][1]) / 2.0;
        z1[2] = (samples[2][2] - samples[2][0]) / 2.0;
        z1[3] = (samples[2][3] - samples[2][1]) / 2.0;
        z2[0] = (samples[2][1] - samples[0][1]) / 2.0;
        z2[1] = (samples[2][2] - samples[0][2]) / 2.0;
        z2[2] = (samples[3][1] - samples[1][1]) / 2.0;
        z2[3] = (samples[3][2] - samples[1][2]) / 2.0;
        z12[0] = (samples[2][2] - samples[2][0] - samples[0][2] + samples[0][0]) / 4.0;
        z12[1] = (samples[2][3] - samples[2][1] - samples[0][3] + samples[0][1]) / 4.0;
        z12[2] = (samples[3][2] - samples[3][0] - samples[1][2] + samples[1][0]) / 4.0;
        z12[3] = (samples[3][3] - samples[3][1] - samples[1][3] + samples[1][1]) / 4.0;
        return BiCubicInterpolationResampling.bcuint(z, z1, z2, z12, index.ki[0], index.kj[0]);
    }

    private static double bcuint(double[] z, double[] z1, double[] z2, double[] z12, double t, double u) {
        double[][] a = new double[4][4];
        BiCubicInterpolationResampling.bcucof(z, z1, z2, z12, a);
        double ansy = 0.0;
        int i = 3;
        while (i >= 0) {
            ansy = t * ansy + ((a[i][3] * u + a[i][2]) * u + a[i][1]) * u + a[i][0];
            --i;
        }
        return ansy;
    }

    private static void bcucof(double[] z, double[] z1, double[] z2, double[] z12, double[][] a) {
        double[] x = new double[16];
        int i = 0;
        while (i < 4) {
            x[i] = z[i];
            x[i + 4] = z1[i];
            x[i + 8] = z2[i];
            x[i + 12] = z12[i];
            ++i;
        }
        double[] cl = new double[16];
        int i2 = 0;
        while (i2 < 16) {
            double xx = 0.0;
            int k = 0;
            while (k < 16) {
                xx += (double)invA[i2][k] * x[k];
                ++k;
            }
            cl[i2] = xx;
            ++i2;
        }
        int l = 0;
        int i3 = 0;
        while (i3 < 4) {
            int j = 0;
            while (j < 4) {
                a[j][i3] = cl[l++];
                ++j;
            }
            ++i3;
        }
    }

    public static void replaceNaNWithMean(double[][] samples) {
        int j;
        double[] sample;
        double mean = 0.0;
        int k = 0;
        int jmax = samples[0].length;
        double[][] dArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            sample = dArray[n2];
            j = 0;
            while (j < jmax) {
                if (!Double.isNaN(sample[j])) {
                    mean += sample[j];
                    ++k;
                }
                ++j;
            }
            ++n2;
        }
        mean /= (double)k;
        dArray = samples;
        n = samples.length;
        n2 = 0;
        while (n2 < n) {
            sample = dArray[n2];
            j = 0;
            while (j < jmax) {
                if (Double.isNaN(sample[j])) {
                    sample[j] = mean;
                }
                ++j;
            }
            ++n2;
        }
    }

    public String toString() {
        return "BiCubic interpolation resampling";
    }
}

