/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import java.io.File;
import org.esa.beam.framework.param.AbstractParamValidator;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;

public class FileValidator
extends AbstractParamValidator {
    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        String trimedText = text.trim();
        if (FileValidator.isAllowedNullText(parameter, trimedText)) {
            return null;
        }
        return new File(trimedText);
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (FileValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        File fValue = FileValidator.castToFile(value);
        if (fValue == null) {
            throw new ParamFormatException(parameter, "Not a file path.");
        }
        return fValue.getPath();
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        this.validateThatNullValueIsAllowed(parameter, value);
        File fValue = FileValidator.castToFile(value);
        if (fValue == null) {
            throw new ParamValidateException(parameter, "Value must be a file path.");
        }
        this.validateThatValueIsInValueSet(parameter, value);
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        File f2;
        File f1 = FileValidator.castToFile(value1);
        if (f1 == (f2 = FileValidator.castToFile(value2))) {
            return true;
        }
        if (f1 == null && f2 != null) {
            return false;
        }
        if (f1 != null && f2 == null) {
            return false;
        }
        return f1.compareTo(f2) == 0;
    }

    protected static File castToFile(Object value) {
        return value instanceof File ? (File)value : null;
    }
}

