/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.glayer.MaskCollectionLayerType;
import org.esa.beam.glayer.MaskLayerType;

public class MaskCollectionLayer
extends CollectionLayer {
    public static final String ID = MaskCollectionLayer.class.getName();
    private final ProductNodeListener maskPNL;
    private RasterDataNode raster;

    public MaskCollectionLayer(MaskCollectionLayerType layerType, RasterDataNode raster, PropertySet configuration) {
        super(layerType, configuration, "Masks");
        Assert.notNull(raster, "raster");
        this.raster = raster;
        this.maskPNL = new MaskPNL();
        this.setId(ID);
        this.getProduct().addProductNodeListener(this.maskPNL);
        this.addListener(new VisibilityLL());
    }

    @Override
    public void disposeLayer() {
        if (this.raster != null) {
            this.getProduct().removeProductNodeListener(this.maskPNL);
            this.raster = null;
        }
    }

    private Product getProduct() {
        return this.raster.getProduct();
    }

    private RasterDataNode getRaster() {
        return this.raster;
    }

    private Layer createLayer(Mask mask) {
        return MaskLayerType.createLayer(this.getRaster(), mask);
    }

    private ImageLayer getMaskLayer(final Mask mask) {
        LayerFilter layerFilter = new LayerFilter(){

            @Override
            public boolean accept(Layer layer) {
                return layer instanceof ImageLayer && mask == layer.getConfiguration().getValue("mask");
            }
        };
        return (ImageLayer)LayerUtils.getChildLayer(LayerUtils.getRootLayer(this), LayerUtils.SEARCH_DEEP, layerFilter);
    }

    private synchronized void updateChildren() {
        LayerFilter layerFilter = new LayerFilter(){

            @Override
            public boolean accept(Layer layer) {
                PropertySet conf = layer.getConfiguration();
                return conf.isPropertyDefined("mask") && conf.getValue("mask") != null;
            }
        };
        List<Layer> maskLayers = LayerUtils.getChildLayers(LayerUtils.getRootLayer(this), LayerUtils.SEARCH_DEEP, layerFilter);
        HashMap<Mask, Layer> currentLayers = new HashMap<Mask, Layer>();
        for (Layer maskLayer : maskLayers) {
            Mask mask = (Mask)maskLayer.getConfiguration().getValue("mask");
            currentLayers.put(mask, maskLayer);
        }
        Mask[] availableMasks = (Mask[])this.raster.getProduct().getMaskGroup().toArray(new Mask[0]);
        HashSet<Layer> unusedLayers = new HashSet<Layer>(maskLayers);
        Mask[] maskArray = availableMasks;
        int n = availableMasks.length;
        int n2 = 0;
        while (n2 < n) {
            Mask availableMask = maskArray[n2];
            Layer layer = (Layer)currentLayers.get(availableMask);
            if (layer != null) {
                unusedLayers.remove(layer);
            } else {
                layer = this.createLayer(availableMask);
                this.getChildren().add(layer);
            }
            layer.setVisible(this.raster.getOverlayMaskGroup().contains(availableMask));
            ++n2;
        }
        for (Layer layer : unusedLayers) {
            layer.dispose();
            Layer layerParent = layer.getParent();
            if (layerParent == null) continue;
            layerParent.getChildren().remove(layer);
        }
    }

    public class MaskPNL
    implements ProductNodeListener {
        @Override
        public synchronized void nodeChanged(ProductNodeEvent event) {
            Mask mask;
            ImageLayer maskLayer;
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Mask && (maskLayer = MaskCollectionLayer.this.getMaskLayer(mask = (Mask)sourceNode)) != null) {
                if (event.getPropertyName().equals("name")) {
                    maskLayer.setName(mask.getName());
                } else {
                    maskLayer.regenerate();
                }
            }
        }

        @Override
        public void nodeDataChanged(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                this.nodeChanged(event);
            }
        }

        @Override
        public void nodeAdded(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                MaskCollectionLayer.this.updateChildren();
            }
        }

        @Override
        public void nodeRemoved(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                MaskCollectionLayer.this.updateChildren();
            }
        }
    }

    private class VisibilityLL
    extends AbstractLayerListener {
        private VisibilityLL() {
        }

        @Override
        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            Object value;
            if ("visible".equals(event.getPropertyName()) && (value = layer.getConfiguration().getValue("mask")) instanceof Mask) {
                Mask mask = (Mask)value;
                ProductNodeGroup<Mask> overlayMaskGroup = MaskCollectionLayer.this.getRaster().getOverlayMaskGroup();
                if (layer.isVisible()) {
                    if (!overlayMaskGroup.contains(mask)) {
                        overlayMaskGroup.add(mask);
                    }
                } else {
                    overlayMaskGroup.remove(mask);
                }
            }
        }
    }
}

