/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;

public class ArrayUtils {
    public static boolean equalArrays(float[] array1, float[] array2, float eps) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (Math.abs(array1[i] - array2[i]) > eps) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArrays(double[] array1, double[] array2, double eps) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (Math.abs(array1[i] - array2[i]) > eps) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArrays(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!ObjectUtils.equalObjects(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getElementIndex(Object element, Object[] array) {
        Guardian.assertNotNull("array", array);
        int i = 0;
        while (i < array.length) {
            if (ObjectUtils.equalObjects(element, array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isMemberOf(Object element, Object[] array) {
        return ArrayUtils.getElementIndex(element, array) >= 0;
    }

    public static void swapArray(byte[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            byte temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(char[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            char temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(short[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            short temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(int[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            int temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(long[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            long temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(float[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            float temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(double[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            double temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(Object[] array) {
        Guardian.assertNotNull("array", array);
        int n = array.length;
        int i1 = 0;
        int i2 = n - 1;
        while (i1 < i2) {
            Object temp = array[i1];
            array[i1] = array[i2];
            array[i2] = temp;
            ++i1;
            --i2;
        }
    }

    public static void swapArray(Object array) {
        Guardian.assertNotNull("array", array);
        if (array instanceof byte[]) {
            ArrayUtils.swapArray((byte[])array);
        } else if (array instanceof char[]) {
            ArrayUtils.swapArray((char[])array);
        } else if (array instanceof short[]) {
            ArrayUtils.swapArray((short[])array);
        } else if (array instanceof int[]) {
            ArrayUtils.swapArray((int[])array);
        } else if (array instanceof long[]) {
            ArrayUtils.swapArray((long[])array);
        } else if (array instanceof float[]) {
            ArrayUtils.swapArray((float[])array);
        } else if (array instanceof double[]) {
            ArrayUtils.swapArray((double[])array);
        } else if (array instanceof Object[]) {
            ArrayUtils.swapArray((Object[])array);
        } else {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    public static int[] recycleOrCreateArray(int[] array, int length) {
        if (array != null && array.length == length) {
            return array;
        }
        return new int[length];
    }

    public static float[] recycleOrCreateArray(float[] array, int length) {
        if (array != null && array.length == length) {
            return array;
        }
        return new float[length];
    }

    public static double[] recycleOrCreateArray(double[] array, int length) {
        if (array != null && array.length == length) {
            return array;
        }
        return new double[length];
    }

    public static int[] addToArray(int[] array, int value) throws IllegalArgumentException {
        Guardian.assertNotNull("array", array);
        int[] newArray = new int[array.length + 1];
        int i = 0;
        while (i < array.length) {
            newArray[i] = array[i];
            ++i;
        }
        newArray[array.length] = value;
        return newArray;
    }

    public static int[] addArrays(int[] firstArray, int[] secondArray) throws IllegalArgumentException {
        Guardian.assertNotNull("firstArray", firstArray);
        Guardian.assertNotNull("secondArray", secondArray);
        int firstArrayLength = firstArray.length;
        int secondArrayLength = secondArray.length;
        int newLength = firstArrayLength + secondArrayLength;
        int[] newArray = new int[newLength];
        int i = 0;
        while (i < firstArrayLength) {
            newArray[i] = firstArray[i];
            ++i;
        }
        i = 0;
        int j = firstArrayLength;
        while (i < secondArrayLength) {
            newArray[j] = secondArray[i];
            ++i;
            ++j;
        }
        return newArray;
    }

    public static int[] createIntArray(int min, int max) {
        int maxInt;
        int minInt;
        if (min < max) {
            minInt = min;
            maxInt = max;
        } else {
            minInt = max;
            maxInt = min;
        }
        int arraySize = maxInt - minInt + 1;
        int[] ints = new int[arraySize];
        int values = minInt;
        int i = 0;
        while (i < ints.length) {
            ints[i] = values++;
            ++i;
        }
        return ints;
    }
}

