/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class PropertyMap {
    private final Properties _properties;
    private PropertyChangeSupport _propertyChangeSupport;
    private Logger _logger;

    public PropertyMap() {
        this(null);
    }

    public PropertyMap(Properties properties) {
        this._properties = properties != null ? properties : new Properties();
        this._logger = BeamLogManager.getSystemLogger();
    }

    public void load(File file) throws IOException {
        Guardian.assertNotNull("file", file);
        FileInputStream istream = new FileInputStream(file);
        this.getProperties().load(istream);
        istream.close();
    }

    public void store(File file, String header) throws IOException {
        Guardian.assertNotNull("file", file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(160000);
        this.getProperties().store(baos, header);
        baos.close();
        String text = baos.toString();
        StringTokenizer st = new StringTokenizer(text, "\n\r", false);
        Object[] lines = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            lines[i] = st.nextElement().toString();
            ++i;
        }
        Arrays.sort(lines);
        BufferedWriter bos = new BufferedWriter(new FileWriter(file));
        int i2 = 0;
        while (i2 < lines.length) {
            bos.write((String)lines[i2]);
            bos.newLine();
            ++i2;
        }
        bos.close();
    }

    public Properties getProperties() {
        return this._properties;
    }

    public Enumeration getPropertyKeys() {
        return this._properties.keys();
    }

    public boolean getPropertyBool(String key) {
        return this.getPropertyBool(key, false);
    }

    public boolean getPropertyBool(String key, boolean defaultValue) {
        return this.getPropertyBool(key, defaultValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getPropertyBool(String key, Boolean defaultValue) {
        String value = this._properties.getProperty(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public void setPropertyBool(String key, boolean value) {
        Guardian.assertNotNullOrEmpty("key", key);
        this.setPropertyBool(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPropertyBool(String key, Boolean newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        Boolean oldValue = this.getPropertyBool(key, null);
        this.changeInternalProperty(key, oldValue, newValue);
    }

    public int getPropertyInt(String key) {
        return this.getPropertyInt(key, 0);
    }

    public int getPropertyInt(String key, int defaultValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        String value = this._properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                String message = "warning: property value of type 'int' expected: " + key + "=" + value + "; using default value: " + defaultValue;
                this._logger.warning(message);
                Debug.trace(message);
            }
        }
        return defaultValue;
    }

    public Integer getPropertyInt(String key, Integer defaultValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        String value = this._properties.getProperty(key);
        if (value != null) {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                String message = "warning: property value of type 'Integer' expected: " + key + "=" + value + "; using default value: " + defaultValue;
                this._logger.warning(message);
                Debug.trace(message);
            }
        }
        return defaultValue;
    }

    public void setPropertyInt(String key, int newValue) {
        this.setPropertyInt(key, new Integer(newValue));
    }

    public void setPropertyInt(String key, Integer newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        Integer oldValue = this.getPropertyInt(key, null);
        this.changeInternalProperty(key, oldValue, newValue);
    }

    public double getPropertyDouble(String key) {
        return this.getPropertyDouble(key, 0.0);
    }

    public double getPropertyDouble(String key, double defaultValue) {
        String value = this._properties.getProperty(key);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                String message = "warning: property value of type 'double' expected: " + key + "=" + value + "; using default value: " + defaultValue;
                this._logger.warning(message);
                Debug.trace(message);
            }
        }
        return defaultValue;
    }

    public Double getPropertyDouble(String key, Double defaultValue) {
        String value = this._properties.getProperty(key);
        if (value != null) {
            try {
                return new Double(value);
            }
            catch (NumberFormatException numberFormatException) {
                String message = "warning: property value of type 'Double' expected: " + key + "=" + value + "; using default value: " + defaultValue;
                this._logger.warning(message);
                Debug.trace(message);
            }
        }
        return defaultValue;
    }

    public void setPropertyDouble(String key, double newValue) {
        this.setPropertyDouble(key, new Double(newValue));
    }

    public void setPropertyDouble(String key, Double newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        Double oldValue = this.getPropertyDouble(key, null);
        this.changeInternalProperty(key, oldValue, newValue);
    }

    public String getPropertyString(String key) {
        return this.getPropertyString(key, "");
    }

    public String getPropertyString(String key, String defaultValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        String property = this._properties.getProperty(key, defaultValue);
        return property;
    }

    public void setPropertyString(String key, String newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        String oldValue = this.getPropertyString(key, null);
        this.changeInternalProperty(key, oldValue, newValue);
    }

    public Color getPropertyColor(String key) {
        return this.getPropertyColor(key, Color.black);
    }

    public Color getPropertyColor(String key, Color defaultValue) {
        Color color;
        Guardian.assertNotNullOrEmpty("key", key);
        String value = this._properties.getProperty(key);
        if (value != null && (color = StringUtils.parseColor(value)) != null) {
            return color;
        }
        return defaultValue;
    }

    public void setPropertyColor(String key, Color newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        Color oldValue = this.getPropertyColor(key, null);
        if (!ObjectUtils.equalObjects(oldValue, newValue)) {
            if (newValue != null) {
                this._properties.setProperty(key, StringUtils.formatColor(newValue));
            } else {
                this._properties.remove(key);
            }
            this.firePropertyChange(key, oldValue, newValue);
        }
    }

    public Font getPropertyFont(String key) {
        return this.getPropertyFont(key, new Font("SansSerif", 0, 12));
    }

    public Font getPropertyFont(String key, Font defaultValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        String fontName = this.getPropertyString(String.valueOf(key) + ".name", null);
        if (fontName != null) {
            int fontStyle = this.getPropertyInt(String.valueOf(key) + ".style", 0);
            int fontSize = this.getPropertyInt(String.valueOf(key) + ".size", 12);
            return new Font(fontName, fontStyle, fontSize);
        }
        return defaultValue;
    }

    public void setPropertyFont(String key, Font newValue) {
        Guardian.assertNotNullOrEmpty("key", key);
        Font oldValue = this.getPropertyFont(key, null);
        if (!ObjectUtils.equalObjects(oldValue, newValue)) {
            if (newValue != null) {
                this._properties.setProperty(String.valueOf(key) + ".name", newValue.getName());
                this._properties.setProperty(String.valueOf(key) + ".style", String.valueOf(newValue.getStyle()));
                this._properties.setProperty(String.valueOf(key) + ".size", String.valueOf(newValue.getSize()));
            } else {
                this._properties.remove(String.valueOf(key) + ".name");
                this._properties.remove(String.valueOf(key) + ".style");
                this._properties.remove(String.valueOf(key) + ".size");
            }
            this.firePropertyChange(key, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(null, listener);
    }

    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        if (listener != null) {
            if (this._propertyChangeSupport == null) {
                this._propertyChangeSupport = new PropertyChangeSupport(this);
            }
            if (key == null) {
                this._propertyChangeSupport.addPropertyChangeListener(listener);
            } else {
                this._propertyChangeSupport.addPropertyChangeListener(key, listener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(null, listener);
    }

    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        if (listener != null && this._propertyChangeSupport != null) {
            if (key == null) {
                this._propertyChangeSupport.removePropertyChangeListener(listener);
            } else {
                this._propertyChangeSupport.removePropertyChangeListener(key, listener);
            }
        }
    }

    protected void firePropertyChange(String key, Object oldValue, Object newValue) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        }
    }

    private void changeInternalProperty(String key, Object oldValue, Object newValue) {
        if (!ObjectUtils.equalObjects(oldValue, newValue)) {
            if (newValue != null) {
                this._properties.setProperty(key, newValue.toString());
            } else {
                this._properties.remove(key);
            }
            this.firePropertyChange(key, oldValue, newValue);
        }
    }
}

