/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import com.bc.ceres.core.Assert;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CsvReader
extends LineNumberReader {
    private static final String WHITESPACE_REGEX = "\\s+";
    private static final String REGEX_TAB = "\\t";
    private static final String REGEX_CHARS = "[\\^$.|?*+()";
    private static final String[] EMPTY_RECORD = new String[0];
    private final char[] separators;
    private final boolean ignoreEmptyLines;
    private final String commentPrefix;
    private final Pattern regExPattern;
    private boolean matchingWhiteSpaces;

    public CsvReader(Reader reader, char[] separators) {
        this(reader, separators, false, null);
    }

    public CsvReader(Reader reader, char[] separators, boolean ignoreEmptyLines, String commentPrefix) {
        super(reader);
        Assert.notNull(separators, "separators");
        Assert.argument(separators.length > 0, "separators.length > 0");
        this.separators = (char[])separators.clone();
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.commentPrefix = commentPrefix;
        this.regExPattern = CsvReader.createPattern(separators);
        this.matchingWhiteSpaces = this.regExPattern.pattern().equals(WHITESPACE_REGEX);
    }

    public final char[] getSeparators() {
        return this.separators;
    }

    public final boolean ignoresEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public final String getCommentPrefix() {
        return this.commentPrefix;
    }

    public String[] readRecord() throws IOException {
        String[] record;
        String line;
        do {
            if ((line = this.readLine()) != null) continue;
            return null;
        } while (this.getCommentPrefix() != null && line.startsWith(this.getCommentPrefix()) || (record = this.split(line)).length == 0 && this.ignoresEmptyLines());
        return record;
    }

    public double[] readDoubleRecord() throws IOException {
        String[] stringRecord = this.readRecord();
        if (stringRecord == null) {
            return null;
        }
        double[] doubleRecord = new double[stringRecord.length];
        int i = 0;
        while (i < doubleRecord.length) {
            try {
                doubleRecord[i] = Double.parseDouble(stringRecord[i]);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
            ++i;
        }
        return doubleRecord;
    }

    public List<String[]> readStringRecords() throws IOException {
        String[] record;
        ArrayList<String[]> vector = new ArrayList<String[]>(256);
        while ((record = this.readRecord()) != null) {
            vector.add(record);
        }
        vector.trimToSize();
        return vector;
    }

    public List<double[]> readDoubleRecords() throws IOException {
        double[] record;
        ArrayList<double[]> vector = new ArrayList<double[]>(256);
        while ((record = this.readDoubleRecord()) != null) {
            vector.add(record);
        }
        vector.trimToSize();
        return vector;
    }

    private String[] split(String line) {
        if (line.isEmpty()) {
            return EMPTY_RECORD;
        }
        if (this.matchingWhiteSpaces) {
            if ((line = line.trim()).isEmpty()) {
                return EMPTY_RECORD;
            }
            return this.regExPattern.split(line, 0);
        }
        return this.trim(this.regExPattern.split(line, -1));
    }

    private String[] trim(String[] splits) {
        int i = 0;
        while (i < splits.length) {
            splits[i] = splits[i].trim();
            ++i;
        }
        return splits;
    }

    private static Pattern createPattern(char[] separators) {
        String regex = CsvReader.createRegex(separators);
        return Pattern.compile(regex);
    }

    private static String createRegex(char[] separators) {
        String s = new String(separators);
        if (s.indexOf(32) >= 0 && s.trim().isEmpty()) {
            return WHITESPACE_REGEX;
        }
        if (separators.length == 1) {
            return CsvReader.encode(separators[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        char[] cArray = separators;
        int n = separators.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            sb.append(CsvReader.encode(separator));
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }

    private static String encode(char separator) {
        if (separator == '\t') {
            return REGEX_TAB;
        }
        int i = REGEX_CHARS.indexOf(separator);
        return i >= 0 ? "\\" + separator : "" + separator;
    }
}

