/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.logging;

import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.core.runtime.internal.DefaultRuntimeConfig;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.logging.BeamFormatter;
import org.esa.beam.util.logging.CacheHandler;

public class BeamLogManager {
    private static Logger logger;

    static {
        try {
            DefaultRuntimeConfig defaultRuntimeConfig = new DefaultRuntimeConfig();
            logger = defaultRuntimeConfig.getLogger();
        }
        catch (RuntimeConfigException runtimeConfigException) {
            logger = Logger.getLogger(System.getProperty("ceres.context", "beam"));
        }
    }

    @Deprecated
    public static String getSystemLoggerName() {
        return logger.getName();
    }

    @Deprecated
    public static void setSystemLoggerName(String systemLoggerName) {
    }

    public static Logger getSystemLogger() {
        return logger;
    }

    @Deprecated
    public static String getLogFilePattern(String logFilenamePrefix) {
        return BeamLogManager.getLogFilePattern(new File(SystemUtils.getApplicationHomeDir(), "log"), logFilenamePrefix);
    }

    @Deprecated
    public static String getLogFilePattern(File outDir, String logFilenamePrefix) {
        Guardian.assertNotNull("outDir", outDir);
        Guardian.assertNotNull("logFilenamePrefix", logFilenamePrefix);
        return new File(outDir, String.valueOf(logFilenamePrefix) + "_%u.%g.log").getPath();
    }

    @Deprecated
    public static void configureSystemLogger(Formatter formatter, boolean consoleEcho) {
        Logger sysLogger = BeamLogManager.getSystemLogger();
        Handler[] sysHandlers = sysLogger.getHandlers();
        boolean hasNoConsoleHandler = true;
        boolean hasNoCacheHandler = true;
        Handler[] handlerArray = sysHandlers;
        int n = sysHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler sysHandler = handlerArray[n2];
            if (sysHandler instanceof ConsoleHandler) {
                hasNoConsoleHandler = false;
            } else if (sysHandler instanceof CacheHandler) {
                hasNoCacheHandler = false;
            }
            ++n2;
        }
        if (hasNoConsoleHandler && consoleEcho) {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            handler.setLevel(Level.FINEST);
            sysLogger.addHandler(handler);
        }
        if (hasNoCacheHandler) {
            sysLogger.addHandler(new CacheHandler());
        }
    }

    @Deprecated
    public static CacheHandler getRegisteredCacheHandler() {
        Logger sysLogger = BeamLogManager.getSystemLogger();
        Handler[] handlers = sysLogger.getHandlers();
        CacheHandler cacheHandler = null;
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof CacheHandler) {
                cacheHandler = (CacheHandler)handler;
                return cacheHandler;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static BeamFormatter createFormatter(String appName, String appVersion, String copyrightInfo) {
        String logHeader = BeamLogManager.createLogHeader(appName, appVersion, copyrightInfo);
        return new BeamFormatter(logHeader);
    }

    @Deprecated
    public static void removeRootLoggerHandlers() {
        Handler[] handlers;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlerArray = handlers = rootLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            rootLogger.removeHandler(handler);
            ++n2;
        }
    }

    @Deprecated
    public static void ensureLogPathFromPatternExists(String logPattern) {
        File logDir = new File(logPattern).getParentFile();
        if (logDir != null && !logDir.exists()) {
            logDir.mkdirs();
        }
    }

    @Deprecated
    public static String createLogHeader(String appName, String appVersion, String copyrightInfo) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Logfile generated by " + appName + ", version " + appVersion);
        printWriter.println(copyrightInfo);
        printWriter.println();
        printWriter.println("\"" + appName + "\" comes with ABSOLUTELY NO WARRANTY.");
        printWriter.println("This is free software, and you are welcome to redistribute it under certain");
        printWriter.println("conditions. See the GNU Library General Public License for details.");
        printWriter.println();
        return stringWriter.toString();
    }
}

