/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import org.esa.beam.util.Debug;
import org.esa.beam.util.math.SingularMatrixException;

public class LinEqSysSolver {
    public static boolean gauss(double[][] a, double[] c, double[] x, int n, double eps) throws SingularMatrixException {
        int j;
        double t;
        int i;
        int k = 0;
        while (k < n - 1) {
            if (!LinEqSysSolver.pivotize(a, c, k, n, eps)) {
                throw new SingularMatrixException();
            }
            i = k + 1;
            while (i < n) {
                t = -a[i][k] / a[k][k];
                j = k + 1;
                while (j < n) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + t * a[k][j];
                    ++j;
                }
                int n3 = i++;
                c[n3] = c[n3] + t * c[k];
            }
            ++k;
        }
        i = 0;
        while (i < n) {
            x[i] = 0.0;
            ++i;
        }
        x[n - 1] = c[n - 1] / a[n - 1][n - 1];
        i = n - 2;
        while (i >= 0) {
            t = 0.0;
            j = i + 1;
            while (j < n) {
                t += a[i][j] * x[j];
                ++j;
            }
            int n4 = i;
            x[n4] = x[n4] + (c[i] - t) / a[i][i];
            --i;
        }
        return true;
    }

    public static boolean gauss_debug(double[][] a, double[] c, double[] x, int n, double eps) {
        Debug.trace("LinEqSysSolver: before gauss() call");
        Debug.trace("LinEqSysSolver: a", a);
        Debug.trace("LinEqSysSolver: c", c);
        Debug.trace("LinEqSysSolver: coeffs", x);
        boolean success = LinEqSysSolver.gauss(a, c, x, n, eps);
        Debug.trace("LinEqSysSolver: after gauss() call");
        Debug.trace("LinEqSysSolver: a", a);
        Debug.trace("LinEqSysSolver: c", c);
        Debug.trace("LinEqSysSolver: coeffs", x);
        return success;
    }

    public static boolean pivotize(double[][] a, double[] c, int k, int n, double eps) {
        double t;
        int pivot = k;
        double maxa = LinEqSysSolver.abs(a[k][k]);
        int i = k + 1;
        while (i < n) {
            t = LinEqSysSolver.abs(a[i][k]);
            if (t > maxa) {
                pivot = i;
                maxa = t;
            }
            ++i;
        }
        boolean success = true;
        if (pivot != k) {
            int j = k;
            while (j < n - 1) {
                t = a[pivot][j];
                a[pivot][j] = a[k][j];
                a[k][j] = t;
                ++j;
            }
            t = c[pivot];
            c[pivot] = c[k];
            c[k] = t;
        } else if (maxa <= eps) {
            success = false;
        }
        return success;
    }

    private static double abs(double x) {
        return x < 0.0 ? -x : x;
    }
}

