/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.HeaderUtil;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.eumetsat.beam.dataio.metop.GenericRecordHeader;

class GiadrRadiance {
    private short rampCalibrationCoefficient;
    private int yearRecentCalibration;
    private int dayRecentCalibration;
    private int primaryCalibrationAlgorithmId;
    private short primaryCalibrationAlgorithmOption;
    private int secondaryCalibrationAlgorithmId;
    private short secondaryCalibrationAlgorithmOption;
    private double[] irTempCoeff1 = new double[4];
    private double[] irTempCoeff2 = new double[4];
    private double[] irTempCoeff3 = new double[4];
    private double[] irTempCoeff4 = new double[4];
    private double[] irTempCoeff5 = new double[4];
    private double[] irTempCoeff6 = new double[4];
    private float[] solarFilteredIrradiance = new float[3];
    private float[] equivalentFilteredWidth = new float[3];
    private float[] centralWavenumber = new float[3];
    private float[] constant1 = new float[3];
    private float[] constant2Slope = new float[3];

    GiadrRadiance() {
    }

    public float getSolarIrradiance(int channel) {
        return this.solarFilteredIrradiance[channel];
    }

    public float getEquivalentWidth(int channel) {
        return this.equivalentFilteredWidth[channel];
    }

    public float getCentralWavenumber(int channel) {
        return this.centralWavenumber[channel - 3];
    }

    public float getConstant1(int channel) {
        return this.constant1[channel - 3];
    }

    public float getConstant2(int channel) {
        return this.constant2Slope[channel - 3];
    }

    public void readRecord(ImageInputStream inputStream) throws IOException {
        GenericRecordHeader grh = new GenericRecordHeader();
        boolean correct = grh.readGenericRecordHeader(inputStream);
        if (!correct) {
            throw new IllegalArgumentException("Bad GRH.");
        }
        this.rampCalibrationCoefficient = inputStream.readShort();
        this.yearRecentCalibration = inputStream.readUnsignedShort();
        this.dayRecentCalibration = inputStream.readUnsignedShort();
        this.primaryCalibrationAlgorithmId = inputStream.readUnsignedShort();
        this.primaryCalibrationAlgorithmOption = inputStream.readShort();
        this.secondaryCalibrationAlgorithmId = inputStream.readUnsignedShort();
        this.secondaryCalibrationAlgorithmOption = inputStream.readShort();
        int i = 0;
        while (i < 4) {
            this.irTempCoeff1[i] = (double)inputStream.readShort() * 0.01;
            this.irTempCoeff2[i] = (double)inputStream.readShort() * 1.0E-5;
            this.irTempCoeff3[i] = (double)inputStream.readShort() * 1.0E-8;
            this.irTempCoeff4[i] = (double)inputStream.readShort() * 1.0E-11;
            this.irTempCoeff5[i] = (double)inputStream.readShort() * 1.0E-14;
            this.irTempCoeff6[i] = (double)inputStream.readShort() * 1.0E-17;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.solarFilteredIrradiance[i] = (float)inputStream.readShort() * 0.1f;
            this.equivalentFilteredWidth[i] = (float)inputStream.readShort() * 0.001f;
            ++i;
        }
        i = 0;
        while (i < 3) {
            float cwScaleFactor = i == 0 ? 0.01f : 0.001f;
            this.centralWavenumber[i] = (float)inputStream.readInt() * cwScaleFactor;
            this.constant1[i] = (float)inputStream.readInt() * 1.0E-5f;
            this.constant2Slope[i] = (float)inputStream.readInt() * 1.0E-6f;
            ++i;
        }
    }

    public MetadataElement getMetaData() {
        MetadataElement element = new MetadataElement("RADIANCE_CONVERSION");
        element.addAttribute(HeaderUtil.createAttribute("RAMP_CALIBRATION_COEFFICIENT", this.rampCalibrationCoefficient));
        element.addAttribute(HeaderUtil.createAttribute("YEAR_RECENT_CALIBRATION", this.yearRecentCalibration, "year"));
        element.addAttribute(HeaderUtil.createAttribute("DAY_RECENT_CALIBRATION", this.dayRecentCalibration, "day"));
        element.addAttribute(HeaderUtil.createAttribute("PRIMARY_CALIBRATION_ALGORITHM_ID", this.primaryCalibrationAlgorithmId));
        element.addAttribute(HeaderUtil.createAttribute("PRIMARY_CALIBRATION_ALGORITHM_OPTION", this.primaryCalibrationAlgorithmOption));
        element.addAttribute(HeaderUtil.createAttribute("SECONDARY_CALIBRATION_ALGORITHM_ID", this.secondaryCalibrationAlgorithmId));
        element.addAttribute(HeaderUtil.createAttribute("SECONDARY_CALIBRATION_ALGORITHM_OPTION", this.secondaryCalibrationAlgorithmOption));
        int i = 0;
        while (i < 4) {
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT1", (float)this.irTempCoeff1[i], "K"));
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT2", (float)this.irTempCoeff2[i], "K/cnt"));
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT3", (float)this.irTempCoeff3[i], "K/cnt^2"));
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT4", (float)this.irTempCoeff4[i], "K/cnt^3"));
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT5", (float)this.irTempCoeff5[i], "K/cnt^4"));
            element.addAttribute(HeaderUtil.createAttribute("IR_TEMPERATURE" + (i + 1) + "_COEFFICIENT6", (float)this.irTempCoeff6[i], "K/cnt^5"));
            ++i;
        }
        i = 0;
        while (i < 3) {
            element.addAttribute(HeaderUtil.createAttribute(String.valueOf(this.getNamePrefix(i)) + "SOLAR_FILTERED_IRRADIANCE", this.solarFilteredIrradiance[i], "W/m^2"));
            element.addAttribute(HeaderUtil.createAttribute(String.valueOf(this.getNamePrefix(i)) + "EQUIVALENT_FILTER_WIDTH", this.equivalentFilteredWidth[i], "m^-6"));
            ++i;
        }
        i = 0;
        while (i < 3) {
            element.addAttribute(HeaderUtil.createAttribute(String.valueOf(this.getNamePrefix(i + 3)) + "CENTRAL_WAVE_NUMBER", this.centralWavenumber[i], "cm^-1"));
            element.addAttribute(HeaderUtil.createAttribute(String.valueOf(this.getNamePrefix(i + 3)) + "CONSTANT1", this.constant1[i], "K"));
            element.addAttribute(HeaderUtil.createAttribute(String.valueOf(this.getNamePrefix(i + 3)) + "CONSTANT2_SLOPE", this.constant2Slope[i], "K/K"));
            ++i;
        }
        return element;
    }

    private String getNamePrefix(int i) {
        return "CH" + AvhrrConstants.CH_STRINGS[i].toUpperCase() + "_";
    }
}

