/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.eumetsat.beam.dataio.metop.GenericRecordHeader;

class InternalPointerRecord {
    GenericRecordHeader header;
    public GenericRecordHeader.RecordClass targetRecordClass;
    public GenericRecordHeader.InstrumentGroup targetInstrumentGroup;
    public int targetRecordSubclass;
    public int targetRecordOffset;

    InternalPointerRecord() {
    }

    public void readRecord(ImageInputStream imageInputStream) throws IOException {
        this.header = new GenericRecordHeader();
        boolean correct = this.header.readGenericRecordHeader(imageInputStream);
        if (!correct || this.header.recordClass != GenericRecordHeader.RecordClass.IPR || this.header.instrumentGroup != GenericRecordHeader.InstrumentGroup.GENERIC) {
            throw new IllegalArgumentException("Bad GRH in IPR");
        }
        byte trc = imageInputStream.readByte();
        if (!GenericRecordHeader.RecordClass.isValid(trc)) {
            throw new IllegalArgumentException("Bad IPR: wrong targetRecordClass=" + trc);
        }
        this.targetRecordClass = GenericRecordHeader.RecordClass.values()[trc];
        byte tig = imageInputStream.readByte();
        if (!GenericRecordHeader.InstrumentGroup.isValid(tig)) {
            throw new IllegalArgumentException("Bad IPR: wrong targetInstrumentGroup" + tig);
        }
        this.targetInstrumentGroup = GenericRecordHeader.InstrumentGroup.values()[tig];
        this.targetRecordSubclass = imageInputStream.readByte();
        this.targetRecordOffset = (int)imageInputStream.readUnsignedInt();
    }

    public void printIPR() {
        System.out.println("IPR");
        System.out.println("targetRecordClass " + (Object)((Object)this.targetRecordClass));
        System.out.println("targetInstrumentGroup " + (Object)((Object)this.targetInstrumentGroup));
        System.out.println("targetRecordSubclass " + this.targetRecordSubclass);
        System.out.println("targetRecordOffset " + this.targetRecordOffset);
    }
}

