/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.color.ColorSpace;
import org.geotools.resources.Classes;

final class ScaledColorSpace
extends ColorSpace {
    private static final float MIN_VALUE = 0.0f;
    private static final float MAX_VALUE = 1.0f;
    private final int band;
    private final float scale;
    private final float offset;

    public ScaledColorSpace(int band, int numComponents, double minimum, double maximum) {
        super(6, numComponents);
        this.band = band;
        double scale = (maximum - minimum) / 1.0;
        double offset = minimum - 0.0 * scale;
        this.scale = (float)scale;
        this.offset = (float)offset;
    }

    public float[] toRGB(float[] values) {
        float value = (values[this.band] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value, value, value};
    }

    public float[] fromRGB(float[] RGB2) {
        float[] values = new float[this.getNumComponents()];
        values[this.band] = (RGB2[0] + RGB2[1] + RGB2[2]) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float[] toCIEXYZ(float[] values) {
        float value = (values[this.band] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value * 0.9642f, value * 1.0f, value * 0.8249f};
    }

    public float[] fromCIEXYZ(float[] RGB2) {
        float[] values = new float[this.getNumComponents()];
        values[this.band] = (RGB2[0] / 0.9642f + RGB2[1] + RGB2[2] / 0.8249f) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float getMinValue(int component) {
        return 0.0f * this.scale + this.offset;
    }

    public float getMaxValue(int component) {
        return 1.0f * this.scale + this.offset;
    }

    public String toString() {
        return Classes.getShortClassName(this) + '[' + this.getMinValue(this.band) + ", " + this.getMaxValue(this.band) + ']';
    }
}

