/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.unit.Unit;
import org.geotools.resources.Classes;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeSpecifier
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8436500582161136302L;
    private NumberRange<?> range;
    private MathTransform1D transform;
    private Unit<?> unit;
    private Color[] colors;

    public RangeSpecifier() {
    }

    public RangeSpecifier(NumberRange<?> range) {
        this.range = range;
    }

    public RangeSpecifier(MathTransform1D transform) {
        this.transform = transform;
    }

    public NumberRange<?> getRange() {
        return this.range;
    }

    public void setRange(NumberRange<?> range) {
        this.range = range;
        this.transform = null;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.transform;
    }

    public void setSampleToGeophysics(MathTransform1D transform) {
        this.transform = transform;
        this.range = null;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public void setUnit(Unit<?> unit) {
        this.unit = unit;
    }

    public Color[] getColors() {
        return this.colors != null ? (Color[])this.colors.clone() : null;
    }

    public void setColors(Color[] colors) {
        this.colors = colors != null ? (Color[])colors.clone() : null;
    }

    @Override
    public RangeSpecifier clone() {
        try {
            return (RangeSpecifier)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public int hashCode() {
        int code = -1156105554;
        if (this.range != null) {
            code += this.range.hashCode();
        }
        if (this.transform != null) {
            code += this.transform.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            RangeSpecifier that = (RangeSpecifier)object;
            return Utilities.equals(this.range, that.range) && Utilities.equals(this.transform, that.transform) && Utilities.equals(this.unit, that.unit) && Arrays.equals(this.colors, that.colors);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this));
        buffer.append('[');
        if (this.range != null) {
            buffer.append(this.range);
        } else if (this.transform != null) {
            buffer.append(this.transform);
        }
        return buffer.append(']').toString();
    }
}

