/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import javax.vecmath.Matrix3d;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix3
extends Matrix3d
implements XMatrix {
    private static final long serialVersionUID = 8902061778871586611L;
    public static final int SIZE = 3;

    public Matrix3() {
        this.setIdentity();
    }

    public Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        super(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Matrix3(AffineTransform transform) {
        this.setMatrix(transform);
    }

    public Matrix3(Matrix matrix) {
        if (matrix.getNumRow() != 3 || matrix.getNumCol() != 3) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public final int getNumRow() {
        return 3;
    }

    public final int getNumCol() {
        return 3;
    }

    public final boolean isIdentity() {
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                if (this.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    public final boolean isAffine() {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.m00) || Double.isNaN(this.m01) || Double.isNaN(this.m02) || Double.isNaN(this.m10) || Double.isNaN(this.m11) || Double.isNaN(this.m12) || Double.isNaN(this.m20) || Double.isNaN(this.m21) || Double.isNaN(this.m22);
    }

    public final void multiply(Matrix matrix) {
        Matrix3d m = matrix instanceof Matrix3d ? (Matrix3d)((Object)matrix) : new Matrix3(matrix);
        this.mul(m);
    }

    public void setMatrix(AffineTransform transform) {
        this.m00 = transform.getScaleX();
        this.m01 = transform.getShearX();
        this.m02 = transform.getTranslateX();
        this.m10 = transform.getShearY();
        this.m11 = transform.getScaleY();
        this.m12 = transform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public boolean equalsAffine(AffineTransform transform) {
        return this.m00 == transform.getScaleX() && this.m01 == transform.getShearX() && this.m02 == transform.getTranslateX() && this.m10 == transform.getShearY() && this.m11 == transform.getScaleY() && this.m12 == transform.getTranslateY() && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    public Matrix3 clone() {
        return (Matrix3)super.clone();
    }
}

