import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Logfile {

	private final String logFile;

	private final DateFormat df;

	public Logfile(String fileName) {
		this.logFile = fileName;
		this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	}

	public void log(String message, LogWindow logWindow) {
		try {
			OutputStream ost = new FileOutputStream(logFile, true);
			BufferedWriter ostream = new BufferedWriter(new OutputStreamWriter(ost));
			Calendar calendar = new GregorianCalendar();
			ostream.write(df.format(calendar.getTime()) + ": " + message);
			ostream.newLine();
			ostream.flush();
			ostream.close();
			ost.close();
		} catch (IOException e) {
			logWindow.log("Error: " + e.getMessage(), true);
			logWindow.log(message, true);			
		}
	}
}
