

public class RolloverQueue {
	
	private final Object [] elements;
	private int writePos;
	private final int maxElements;

	public RolloverQueue(int maxElements) {
		this.maxElements = maxElements;
		elements = new Object[maxElements];
		writePos = 0;
	}

	public boolean addNew(Object element) {
		if (maxElements > 0) {
			for (int i = 0; i < maxElements; ++i)
				if (element.equals(elements[i]))
					return false;
			elements[writePos] = element;
			writePos = (writePos + 1) % maxElements;
		}
		return true;
	}
}
