@echo off
echo ATDNET Sferics BUFR Import and Processing
echo Lightning strokes and flashes
echo For quick visualization of the sferics file use BUFRDisplay
echo Relevant coordinate variables are: 12-latitude (code 5001), 13-longitude (code 6001)
echo Relevant lightning parameter is: 22-lightning stroke/flash (code 20124)
echo File name convention is: W_C_ISFX04_EGRR_20140425024800_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin
echo Temporal resolution 15 minutes, starting at 00:03 UTC
echo Therefore at 00:03, 00:18, 00:33, 00:48, 01:03, etc
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*

copy "%InputDrive%\%InputDir%\W_C_ISFX04_EGRR_%shortfilename1%00_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin" %OutputDrive%\%OutputDir%\*.* > NUL

if exist "%OutputDrive%\%OutputDir%\W_C_ISFX04_EGRR_%shortfilename1%00_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin" GOTO START

:START1
if not exist "%InputDrive%\%InputDir%\W_C_ISFX04_EGRR_%shortfilename1%00_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_C_ISFX04_EGRR_%shortfilename1%00_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

ren W_C_ISFX04_EGRR_%shortfilename1%00_UK-MetOffice-Sferics-Africa-BUFR-15minute_concatenation.bin sferics%shortfilename1%

echo Sferics import table and point map creation


copy sferics%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL


cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

cmd /c bufrextract.exe sferics%shortfilename1% -oddump.csv >mess.txt 2>&1


cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\sferics%shortfilename1%"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 9 8 23 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS 
echo.

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ATDNET_sferics_%shortfilename1%'.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,x(value.dom{-180:180:0.0001}),y(value.dom{-90:90:0.0001}),lightning(value.dom{0:10:1}));
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ATDNET_sferics_%shortfilename1%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\ATDNET_sferics_%shortfilename1%',LatlonWGS84);

:END
del dump*.csv
del ConvertCSV.class
del sferics%shortfilename1%

"%IlwDir%\ilwis.exe" -C closeall



:END
"%IlwDir%\ilwis.exe" -C closeall