@echo off
rem file name convention is S-CM_SISmm202003010000410231000101MA.nc
rem only yyyymmdd is required

set longfilename=%1
set shortfilename1=%longfilename:~0,6%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*


copy "%InputDrive%\%InputDir%\S-CM_SISmm%shortfilename1%*.nc" "%OutputDrive%\%OutputDir%\*.*"


if not exist "%OutputDrive%\%OutputDir%\S-CM_SISmm%shortfilename1%*.nc" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-CM_SISmm%shortfilename1%*.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

ren %OutputDrive%\%OutputDir%\S-CM_SISmm%shortfilename1%*.nc S-CM_SISmm%shortfilename1%.nc 

"%gdalDir%\gdal_translate" -of ilwis hdf5:"S-CM_SISmm%shortfilename1%.nc"://SIS "%OutputDrive%\%OutputDir%\T_SIS_%shortfilename1%"

"%IlwDir%\ilwis.exe" -C CM_SIS_%shortfilename1%.mpr:=MapMirrorRotate(T_SIS_%shortfilename1%,MirrHor)

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\CM_SIS_%shortfilename1%.mpr %UtilDir%\CM_SIS;




del T_SIS_%shortfilename1%.mp*
del *.xml
del S-CM_SISmm%shortfilename1%.nc 

:END
"%IlwDir%\ilwis.exe" -C closeall