@echo off 
rem input file should be locally available in NC4 format - global coverage expected
echo data to be downloaded from "https://portal.nccs.nasa.gov/cgi-lats4d/webform.cgi?&i=GEOS-5/fp/0.25_deg/assim/tavg1_2d_lnd_Nx"
echo whole filename expected as input filename, including extension
echo input data expected in other folder
echo file name expected = tavg1_2d_lnd_Nx-yyyymmddhhmmoutput.25005.webform.nc4, note yyyymmddhhmm is time stamp generated when requesting the data
echo single parameter per file expected

set longfilename=%1
set shortfilename1=%longfilename%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*
echo.
echo.
echo %shortfilename1%

copy "%inputDrive%\%InputDir%\%shortfilename1%" 


echo off
if not exist "%OutputDrive%\%OutputDir%\%shortfilename1%"  goto MESSAGE
echo The file(s) "%OutputDrive%\%OutputDir%\%shortfilename1%" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your File Name settings
echo Your current File Name used is %shortfilename1%
echo Data is retrieved from %inputDrive%\%InputDir%\



pause

GOTO END

:START

rem import data in ilwis format

ren %shortfilename1% geos5_land.nc4

"%gdalDir%\gdal_translate.exe" -of ilwis geos5_land.nc4 geos5_temp.mpl

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GEOS5_land.mpl:=MapListApplic(geos5_temp,MapMirrorRotate(##,MirrHor))
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\GEOS5_land_*.mpr %UtilDir%\geos5_land.grf


rem delete obsolete objects

del geos5_land.nc4
del geos5_temp.mpl
del geos5_temp.aux.xml
del geos5_temp_band*.*



:END
"%IlwDir%\ilwis.exe" -C closeall