@echo off

rem Himawari-8 import
rem 10 blocks are required - of 550 lines and 5500 columns each
rem all can have different header size
rem java application ReadHimawariHeader.java and ReadHimawariHeader.class are used to read header size
rem data blocks are imported in ilwis, with known header size for each block
rem subsequently all data blocks are merged into temporary single file
rem dummy mpr is used 
rem finally coordinate and georeference info is assigned
rem file name convention is IMG_DK01VIS_201701270000_001.bz2 for VIS band only
rem file name convention is IMG_DK01IR1_201701270000_001.bz2 to IMG_DK01IR4_201701271305_006.bz2, for bands IR1, IR2, IR3 and IR4
rem file name convention is IMG_DK01B04_201701270000_001.bz2 to IMG_DK01B16_201701270000_001.bz2, for bands 04, 05, 06, 09, 10, 11, 12, 14, 16




set longfilename=%1
set shortfilename1=%longfilename:~0,16%
set shortfilename2=%longfilename:~0,11%
set shortfilename3=%longfilename:~12,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*
echo import bands 04, 05, 06, 09, 10, 11, 12, 14, 16 images

copy "%InputDrive%\%InputDir%\IMG_DK01B??_%shortfilename2%?_0??.bz2

if not exist "%OutputDrive%\%OutputDir%\IMG_DK01B04_%shortfilename2%?_001.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\IMG_DK01B**_%shortfilename2%?_0??.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

rem ===========================B04-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B04_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B04 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=0.86
echo unit is albedo in percentage from 0 to 100
echo linear conversion applied 0:=-0.10 to 
1023:=100.00

rem read header size and import block

rem for block1
rename IMG_DK01B04_%shortfilename2%?_001 IMG_DK01B04_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B04_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B04_%shortfilename2%?_002 IMG_DK01B04_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B04_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B04_%shortfilename2%?_003 IMG_DK01B04_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B04_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block4
rename IMG_DK01B04_%shortfilename2%?_004 IMG_DK01B04_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B04_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B04_%shortfilename2%?_005 IMG_DK01B04_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B04_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B04_%shortfilename2%?_006 IMG_DK01B04_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B04_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B04_%shortfilename2%?_007 IMG_DK01B04_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B04_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B04_%shortfilename2%?_008 IMG_DK01B04_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B04_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B04_%shortfilename2%?_009 IMG_DK01B04_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B04_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B04_%shortfilename2%?_010 IMG_DK01B04_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B04_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B04_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# him8_%longfilename:~0,12%_B04t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ him8_%longfilename:~0,12%_B04t him_8allb.mpr > him8_%longfilename:~0,12%_B04t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf him8_%longfilename:~0,12%_B04t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B04'.mpr{dom=value;vr=0.00:100.00:0.01}:='him8_%longfilename:~0,12%_B04t'*0.097751711


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B04_%shortfilename2%?_0??.*
del block??.mp*
del him8_%longfilename:~0,12%_B04t.mp*
rem =================================B04-End===================================


rem ===========================B05-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B05_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B05 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=1.6
echo unit is albedo in percentage from 0 to 100
echo linear conversion applied 0:=-0.10 to 
1023:=100.00

rem read header size and import block

rem for block1
rename IMG_DK01B05_%shortfilename2%?_001 IMG_DK01B05_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B05_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B05_%shortfilename2%?_002 IMG_DK01B05_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B05_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B05_%shortfilename2%?_003 IMG_DK01B05_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B05_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B05_%shortfilename2%?_004 IMG_DK01B05_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B05_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B05_%shortfilename2%?_005 IMG_DK01B05_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B05_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B05_%shortfilename2%?_006 IMG_DK01B05_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B05_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B05_%shortfilename2%?_007 IMG_DK01B05_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B05_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B05_%shortfilename2%?_008 IMG_DK01B05_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B05_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B05_%shortfilename2%?_009 IMG_DK01B05_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B05_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B05_%shortfilename2%?_010 IMG_DK01B05_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B05_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B05_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# him8_%longfilename:~0,12%_B05t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ him8_%longfilename:~0,12%_B05t him_8allb.mpr > him8_%longfilename:~0,12%_B05t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf him8_%longfilename:~0,12%_B05t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B05'.mpr{dom=value;vr=0.00:100.00:0.01}:='him8_%longfilename:~0,12%_B05t'*0.097751711


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B05_%shortfilename2%?_0??.*
del block??.mp*
del him8_%longfilename:~0,12%_B05t.mp*
rem =================================B05-End===================================

rem ===========================B06-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B06_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B06 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=2.3
echo unit is albedo in percentage from 0 to 100
echo linear conversion applied 0:=-0.10 to 
1023:=100.00

rem read header size and import block

rem for block1
rename IMG_DK01B06_%shortfilename2%?_001 IMG_DK01B06_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B06_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B06_%shortfilename2%?_002 IMG_DK01B06_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B06_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B06_%shortfilename2%?_003 IMG_DK01B06_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B06_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B06_%shortfilename2%?_004 IMG_DK01B06_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B06_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B06_%shortfilename2%?_005 IMG_DK01B06_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B06_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B06_%shortfilename2%?_006 IMG_DK01B06_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B06_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B06_%shortfilename2%?_007 IMG_DK01B06_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B06_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B06_%shortfilename2%?_008 IMG_DK01B06_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B06_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B06_%shortfilename2%?_009 IMG_DK01B06_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B06_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B06_%shortfilename2%?_010 IMG_DK01B06_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B06_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B06_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# him8_%longfilename:~0,12%_B06t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ him8_%longfilename:~0,12%_B06t him_8allb.mpr > him8_%longfilename:~0,12%_B06t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf him8_%longfilename:~0,12%_B06t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B06'.mpr{dom=value;vr=0.00:100.00:0.01}:='him8_%longfilename:~0,12%_B06t'*0.097751711


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B06_%shortfilename2%?_0??.*
del block??.mp*
del him8_%longfilename:~0,12%_B06t.mp*
rem =================================B06-End===================================

rem ===========================B09-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B09_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B09 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=7.0
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit applied:  y=a+bx+cx^2+dx^3...
echo Coefficient Data used:
echo a =	328.25842
echo b =	0.20469385
echo c =	-0.0053857881
echo d =	4.3212106e-005
echo e =	-1.7236842e-007
echo f =	3.7541523e-010
echo g =	-4.5470061e-013
echo h =	2.8749851e-016
echo i =	-7.4001702e-020

rem read header size and import block

rem for block1
rename IMG_DK01B09_%shortfilename2%?_001 IMG_DK01B09_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B09_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B09_%shortfilename2%?_002 IMG_DK01B09_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B09_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B09_%shortfilename2%?_003 IMG_DK01B09_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B09_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B09_%shortfilename2%?_004 IMG_DK01B09_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B09_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B09_%shortfilename2%?_005 IMG_DK01B09_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B09_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B09_%shortfilename2%?_006 IMG_DK01B09_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B09_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B09_%shortfilename2%?_007 IMG_DK01B09_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B09_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B09_%shortfilename2%?_008 IMG_DK01B09_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B09_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B09_%shortfilename2%?_009 IMG_DK01B09_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B09_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B09_%shortfilename2%?_010 IMG_DK01B09_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B09_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B09_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B09t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B09t him_8allb.mpr > B09t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B09t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B09'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.25842+0.20469385*B09t+-0.0053857881*POW(B09t,2)+4.3212106e-005*POW(B09t,3)+-1.7236842e-007*POW(B09t,4)+3.7541523e-010*POW(B09t,5)+-4.5470061e-013*POW(B09t,6)+2.8749851e-016*POW(B09t,7)+-7.4001702e-020*POW(B09t,8)



rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B09_%shortfilename2%?_0??.*
del block??.mp*
del B09t.mp*
rem =================================B09-End===================================


rem ===========================B10-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B10_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B10 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=7.3
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	328.21632
echo b =	0.19786897
echo c =	-0.0052845436
echo d =	4.237816e-005
echo e =	-1.6912356e-007
echo f =	3.6860612e-010
echo g =	-4.4679592e-013
echo h =	2.8271887e-016
echo i =	-7.2827239e-020

rem read header size and import block

rem for block1
rename IMG_DK01B10_%shortfilename2%?_001 IMG_DK01B10_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B10_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B10_%shortfilename2%?_002 IMG_DK01B10_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B10_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B10_%shortfilename2%?_003 IMG_DK01B10_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B10_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block4
rename IMG_DK01B10_%shortfilename2%?_004 IMG_DK01B10_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B10_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B10_%shortfilename2%?_005 IMG_DK01B10_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B10_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B10_%shortfilename2%?_006 IMG_DK01B10_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B10_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B10_%shortfilename2%?_007 IMG_DK01B10_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B10_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B10_%shortfilename2%?_008 IMG_DK01B10_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B10_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B10_%shortfilename2%?_009 IMG_DK01B10_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B10_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B10_%shortfilename2%?_010 IMG_DK01B10_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B10_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B10_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B10t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B10t him_8allb.mpr > B10t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B10t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B10'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.21632+0.19786897*B10t+-0.0052845436*POW(B10t,2)+4.237816e-005*POW(B10t,3)+-1.6912356e-007*POW(B10t,4)+3.6860612e-010*POW(B10t,5)+-4.4679592e-013*POW(B10t,6)+2.8271887e-016*POW(B10t,7)+-7.2827239e-020*POW(B10t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B10_%shortfilename2%?_0??.*
del block??.mp*
del B10t.mp*
rem =================================B10-End===================================


rem ===========================B11-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B11_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B11 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=8.6
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	328.18648
echo b =	0.1699305
echo c =	-0.0048307696
echo d =	3.8603988e-005
echo e =	-1.5405482e-007
echo f =	3.361233e-010
echo g =	-4.0809898e-013
echo h =	2.587433e-016
echo i =	-6.6798148e-020

rem read header size and import block

rem for block1
rename IMG_DK01B11_%shortfilename2%?_001 IMG_DK01B11_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B11_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B11_%shortfilename2%?_002 IMG_DK01B11_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B11_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B11_%shortfilename2%?_003 IMG_DK01B11_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B11_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B11_%shortfilename2%?_004 IMG_DK01B11_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B11_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B11_%shortfilename2%?_005 IMG_DK01B11_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B11_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B11_%shortfilename2%?_006 IMG_DK01B11_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B11_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B11_%shortfilename2%?_007 IMG_DK01B11_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B11_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B11_%shortfilename2%?_008 IMG_DK01B11_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B11_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B11_%shortfilename2%?_009 IMG_DK01B11_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B11_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B11_%shortfilename2%?_010 IMG_DK01B11_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B11_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B11_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B11t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B11t him_8allb.mpr > B11t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B11t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B11'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.18648+0.1699305*B11t+-0.0048307696*POW(B11t,2)+3.8603988e-005*POW(B11t,3)+-1.5405482e-007*POW(B11t,4)+3.361233e-010*POW(B11t,5)+-4.0809898e-013*POW(B11t,6)+2.587433e-016*POW(B11t,7)+-6.6798148e-020*POW(B11t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B11_%shortfilename2%?_0??.*
del block??.mp*
del B11t.mp*
rem =================================B11-End===================================

rem ===========================B12-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B12_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B12 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=9.6
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	327.93646
echo b =	0.17797278
echo c =	-0.0050949424
echo d =	4.0549317e-005
echo e =	-1.6144032e-007
echo f =	3.5165465e-010
echo g =	-4.263646e-013
echo h =	2.6997611e-016
echo i =	-6.9608923e-020

rem read header size and import block

rem for block1
rename IMG_DK01B12_%shortfilename2%?_001 IMG_DK01B12_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B12_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B12_%shortfilename2%?_002 IMG_DK01B12_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B12_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B12_%shortfilename2%?_003 IMG_DK01B12_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B12_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B12_%shortfilename2%?_004 IMG_DK01B12_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B12_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B12_%shortfilename2%?_005 IMG_DK01B12_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B12_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B12_%shortfilename2%?_006 IMG_DK01B12_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B12_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B12_%shortfilename2%?_007 IMG_DK01B12_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B12_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B12_%shortfilename2%?_008 IMG_DK01B12_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B12_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B12_%shortfilename2%?_009 IMG_DK01B12_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B12_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B12_%shortfilename2%?_010 IMG_DK01B12_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B12_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B12_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B12t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B12t him_8allb.mpr > B12t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B12t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B12'.mpr{dom=value;vr=130.000:330.000:0.001}:=327.93646+0.17797278*B12t+-0.0050949424*POW(B12t,2)+4.0549317e-005*POW(B12t,3)+-1.6144032e-007*POW(B12t,4)+3.5165465e-010*POW(B12t,5)+-4.263646e-013*POW(B12t,6)+2.6997611e-016*POW(B12t,7)+-6.9608923e-020*POW(B12t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B12_%shortfilename2%?_0??.*
del block??.mp*
del B12t.mp*
rem =================================B12-End===================================

rem ===========================B14-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B14_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B14 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=11.2
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	328.58006
echo b =	0.081671071
echo c =	-0.0033354009
echo d =	2.656005e-005
echo e =	-1.0630932e-007
echo f =	2.3298238e-010
echo g =	-2.843789e-013
echo h =	1.8135182e-016
echo i =	-4.7113736e-020


rem read header size and import block

rem for block1
rename IMG_DK01B14_%shortfilename2%?_001 IMG_DK01B14_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B14_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B14_%shortfilename2%?_002 IMG_DK01B14_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B14_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B14_%shortfilename2%?_003 IMG_DK01B14_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B14_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B14_%shortfilename2%?_004 IMG_DK01B14_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B14_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B14_%shortfilename2%?_005 IMG_DK01B14_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B14_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B14_%shortfilename2%?_006 IMG_DK01B14_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B14_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B14_%shortfilename2%?_007 IMG_DK01B14_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B14_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B14_%shortfilename2%?_008 IMG_DK01B14_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B14_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B14_%shortfilename2%?_009 IMG_DK01B14_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B14_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B14_%shortfilename2%?_010 IMG_DK01B14_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B14_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B14_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B14t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B14t him_8allb.mpr > B14t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B14t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B14'.mpr{dom=value;vr=130.000:330.000:0.001}:=328.58006+0.081671071*B14t+-0.0033354009*POW(B14t,2)+2.656005e-005*POW(B14t,3)+-1.0630932e-007*POW(B14t,4)+2.3298238e-010*POW(B14t,5)+-2.843789e-013*POW(B14t,6)+1.8135182e-016*POW(B14t,7)+-4.7113736e-020*POW(B14t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B14_%shortfilename2%?_0??.*
del block??.mp*
del B14t.mp*
rem =================================B14-End===================================

rem ===========================B16-start==========================

"%UtilDir%\7z.exe" e IMG_DK01B16_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL



echo B16 channel is imported - wait till routine is completed
echo Central wavelength (Micron) (nominal values)=13.3
echo unit is temperature in degree Kelvin
echo 8th Degree Polynomial Fit:  y=a+bx+cx^2+dx^3...
echo Coefficient Data:
echo a =	329.02511
echo b =	0.011486566
echo c =	-0.0021558087
echo d =	1.7139918e-005
echo e =	-6.8925293e-008
echo f =	1.5186026e-010
echo g =	-1.8646887e-013
echo h =	1.1967273e-016
echo i =	-3.1305822e-020

rem read header size and import block

rem for block1
rename IMG_DK01B16_%shortfilename2%?_001 IMG_DK01B16_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01B16_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block2
rename IMG_DK01B16_%shortfilename2%?_002 IMG_DK01B16_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01B16_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block3
rename IMG_DK01B16_%shortfilename2%?_003 IMG_DK01B16_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01B16_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal


rem for block4
rename IMG_DK01B16_%shortfilename2%?_004 IMG_DK01B16_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01B16_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block5
rename IMG_DK01B16_%shortfilename2%?_005 IMG_DK01B16_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01B16_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block6
rename IMG_DK01B16_%shortfilename2%?_006 IMG_DK01B16_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01B16_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block7
rename IMG_DK01B16_%shortfilename2%?_007 IMG_DK01B16_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01B16_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block8
rename IMG_DK01B16_%shortfilename2%?_008 IMG_DK01B16_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01B16_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block9
rename IMG_DK01B16_%shortfilename2%?_009 IMG_DK01B16_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01B16_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem for block10
rename IMG_DK01B16_%shortfilename2%?_010 IMG_DK01B16_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01B16_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)


set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01B16_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)
endlocal

rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# B16t.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ B16t him_8allb.mpr > B16t.mpr


"%IlwDir%\ilwis.exe"  -C setgrf B16t.mpr 'UtilDir\himawari_8'.grf
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_B16'.mpr{dom=value;vr=130.000:330.000:0.001}:=329.02511+0.011486566*B16t+-0.0021558087*POW(B16t,2)+1.7139918e-005*POW(B16t,3)+-6.8925293e-008*POW(B16t,4)+1.5186026e-010*POW(B16t,5)+-1.8646887e-013*POW(B16t,6)+1.1967273e-016*POW(B16t,7)+-3.1305822e-020*POW(B16t,8)


rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01B16_%shortfilename2%?_0??.*
del block??.mp*
del B16t.mp*
rem =================================B16-End===================================

:END
"%IlwDir%\ilwis.exe" -C closeall