@Echo off
rem import GOES 16 ABI from geonetcast
rem file name convention OR_ABI-L1b-RadF-M6C04_G16_s20190201830345_e20190201841112_c20190201841134.nc
rem or OR_ABI-L1b-RadF-M6C03_G16_s20190211800344_e20190211811111_c20190211811160-119000_0.nc
rem temporal resolution is half hourly

echo off


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set shortfilename2=%shortfilename1:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*

echo %shortfilename2%

:manualDATE
echo.
echo.


echo.
echo.

rem get date from interface - user as longfilename
set ldt=%longfilename:~0,8%


SETLOCAL

set yy=%ldt:~0,4%
set mm=%ldt:~4,2%
set dd=%ldt:~6,2%

set /a "yy=10000%yy% %%10000,mm=100%mm% %% 100,dd=100%dd% %% 100"
set /a JD=dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4
set /a "yy=10000%yy% %%10000,mm=1,dd=1"
set /a JD-=-1+dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4




if %JD% LEQ 9 (
set JD=00%JD%
)

rem echo %JD%

IF %JD% GEQ 10 (
	IF %JD% LSS 100 (
	set JD=0%JD%)
)

rem echo %JD%

if %JD% GEQ 100 (
set JD=%JD%
)

set full_doy=%ldt:~0,4%%JD%
echo day of year string and time (hhmm) used: %full_doy%%shortfilename2%
echo calculated DoY: %JD%
echo Current entered date [yyyymmdd]: %ldt%

echo.

echo processing channel 01 to channel 03
echo.
copy "%InputDrive%\%InputDir%\OR_ABI-L1b-RadF-M6C01_G16_s%full_doy%%shortfilename2%*.nc"
copy "%InputDrive%\%InputDir%\OR_ABI-L1b-RadF-M6C02_G16_s%full_doy%%shortfilename2%*.nc"
copy "%InputDrive%\%InputDir%\OR_ABI-L1b-RadF-M6C03_G16_s%full_doy%%shortfilename2%*.nc"

if not exist "%OutputDrive%\%OutputDir%\OR_ABI-L1b-RadF-M6C01_G16_s%full_doy%%shortfilename2%*.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\OR_ABI-L1b-RadF-M6C01 to 16_s%full_doy%%shortfilename2%*.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1% and Day of Year settings %full_doy%%shortfilename2%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
echo.
echo channel 01
ren "OR_ABI-L1b-RadF-M6C01_G16_s%full_doy%%shortfilename2%*.nc" "OR_ABI-L1b-RadF-M6C01_G16_s%shortfilename1%.nc"
"%gdalDir%\gdal_translate" -of ilwis HDF5:"OR_ABI-L1b-RadF-M6C01_G16_s%shortfilename1%.nc"://Rad ABI_B01_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\ABI_B01_%shortfilename1%.mpr %UtilDir%\abi_east;

echo.
echo channel 02
ren "OR_ABI-L1b-RadF-M6C02_G16_s%full_doy%%shortfilename2%*.nc" "OR_ABI-L1b-RadF-M6C02_G16_s%shortfilename1%.nc"
"%gdalDir%\gdal_translate" -of ilwis HDF5:"OR_ABI-L1b-RadF-M6C02_G16_s%shortfilename1%.nc"://Rad ABI_B02_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\ABI_B02_%shortfilename1%.mpr %UtilDir%\abi_east;

echo.
echo channel 03
ren "OR_ABI-L1b-RadF-M6C03_G16_s%full_doy%%shortfilename2%*.nc" "OR_ABI-L1b-RadF-M6C03_G16_s%shortfilename1%.nc"
"%gdalDir%\gdal_translate" -of ilwis HDF5:"OR_ABI-L1b-RadF-M6C03_G16_s%shortfilename1%.nc"://Rad ABI_B03_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\ABI_B03_%shortfilename1%.mpr %UtilDir%\abi_east;

ping -n 11 -w 1000 127.0.0.1 > nul

echo.
echo.
echo Processing True Colour Composite
echo Wait till routine is finished
ping -n 11 -w 1000 127.0.0.1 > nul

"%IlwDir%\ilwis.exe" -C ABI_B01_%shortfilename1%_rad{dom=value;vr=-10:804.5:0.001}:=ABI_B01_%shortfilename1%*0.81210637-25.936647
"%IlwDir%\ilwis.exe" -C ABI_B02_%shortfilename1%_rad{dom=value;vr=-10:629:0.001}:=ABI_B02_%shortfilename1%*0.15859237-20.289911
"%IlwDir%\ilwis.exe" -C ABI_B03_%shortfilename1%_rad{dom=value;vr=-10:373.5:0.001}:=ABI_B03_%shortfilename1%*0.37691253-12.037643 

"%IlwDir%\ilwis.exe" -C green_rad{dom=value;vr=-10:804.5:0.001}:=0.45*ABI_B02_%shortfilename1%_rad+0.1*ABI_B03_%shortfilename1%_rad+0.45*ABI_B01_%shortfilename1%_rad

"%IlwDir%\ilwis.exe" -C blue.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear(ABI_B01_%shortfilename1%_rad,1.000000,image.dom)
"%IlwDir%\ilwis.exe" -C red.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear(ABI_B02_%shortfilename1%_rad,1.000000,image.dom)
"%IlwDir%\ilwis.exe" -C green.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear(green_rad,1.000000,image.dom)


"%IlwDir%\ilwis.exe" -C ABI_TC_GE_%shortfilename1%.mpr:=MapColorComp24Linear(mlist(red,green,blue),10.000000:100.000000,10.000000:100.000000,10.000000:100.000000)

del ABI_B0?_%shortfilename1%_rad.mp*
del ABI_B0?_%shortfilename1%_rad.hi*
del green_rad.mp*
del green_rad.hi*
del OR_ABI-L1b-RadF-M6C??_G16_s%shortfilename1%.nc
del ABI_B??_%shortfilename1%.mpr.aux.xml
del ABI_B??_%shortfilename1%.mp*

del blue.mp*
del green.mp*
del red.mp*



:END
"%IlwDir%\ilwis.exe" -C closeall

