@echo off
echo Data retrieved from https://gpm1.gesdisc.eosdis.nasa.gov/data/GPM_L3/GPM_3IMERGHH.06/
echo Data resides under year and julian day dated sub-directories
echo 48 files per day are downloaded and each file contains a 1/2 hr time step
echo unit half hourly files are in mm/hr
echo.
echo.
 
set longfilename=%1
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

Rem clean output folder
if exist .urs_cookies del .urs_cookies
rem NUL > .urs_cookies 
echo.>.urs_cookies 
if exist .wget-hsts del .wget-hsts
if exist inputparam.bat del inputparam.bat
if exist index.html del index.html

Rem retrieve day of your for input folder directory structure
set ldt=%longfilename%

SETLOCAL

set yy=%ldt:~0,4%
set mm=%ldt:~4,2%
set dd=%ldt:~6,2%

set /a "yy=10000%yy% %%10000,mm=100%mm% %% 100,dd=100%dd% %% 100"
set /a JD=dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4
set /a "yy=10000%yy% %%10000,mm=1,dd=1"
set /a JD-=-1+dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4

if %JD% LEQ 9 (
set JD=00%JD%
)

rem echo %JD%

IF %JD% GEQ 10 (
	IF %JD% LSS 100 (
	set JD=0%JD%)
)

rem echo %JD%

if %JD% GEQ 100 (
set JD=%JD%
)

set full_doy=%ldt:~0,4%%JD%
echo calculated DoY: %JD%
echo timestamp used %full_doy%
echo Current entered date [yyyymmdd]: %ldt%

echo.
echo.

rem prepare for wget to get access to data portal

set /p user=Enter your User Name:

"%UtilDir%\wget\wget.exe" --load-cookies .urs_cookies --save-cookies .urs_cookies --auth-no-challenge=on --keep-session-cookies --user=%user% --ask-password -c --no-parent -r -N -nH --cut-dirs=5 --reject="index.html*" -e robots=off https://gpm1.gesdisc.eosdis.nasa.gov/data/GPM_L3/GPM_3IMERGHH.06/%ldt:~0,4%/%JD%/


echo off
if not exist "%OutputDrive%\%OutputDir%\3B-HHR.MS.MRG.3IMERG.*.HDF5"  goto MESSAGE


echo.
echo All the 48 "3B-HHR.MS.MRG.3IMERG.*.HDF5" files have been successfully retrieved to your current working directory
echo.
echo.


GOTO START

:MESSAGE
echo The input files are not found.
echo Check your directory and date stamp settings, note the day of the year stamp
echo Your current date stamp used is %ldt%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

echo set OutputDrive=%4>inputparam.bat
echo set OutputDir=%5>>inputparam.bat
echo set GdalDir=%6>>inputparam.bat
echo set IlwDir=%7>>inputparam.bat
echo set UtilDir=%8>>inputparam.bat


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

copy "%IlwDir%\Extensions\geonetcast-Toolbox\toolbox_batchroutines\gpm_imerg_loop.bat" >nul

for %%j in (3B-HHR.MS.MRG.3IMERG.*.HDF5) do cmd /c gpm_imerg_loop.bat %%j


echo.
echo Creating aggregated daily precipitation map

copy "%UtilDir%\mpl_substitutename.bat" >nul
copy "%UtilDir%\gpm_imerg_master.mpl" >nul

cmd /c mpl_substitutename.bat ______ _%ldt%_ gpm_imerg_master.mpl > gpm_imerg_%ldt%.mpl
rem calculate sum PCP - correct for unit
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\Sum_%ldt%.mpr:=MapMaplistStatistics(gpm_imerg_%ldt%.mpl,Sum)
rem finmap is sum/2!!!!!
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\imerg_Sum_%ldt%:=Sum_%ldt%/2


del %OutputDrive%\%OutputDir%\inputparam.bat
del %OutputDrive%\%OutputDir%\gpm_imerg_loop.bat
del %OutputDrive%\%OutputDir%\3B-HHR.MS.MRG.3IMERG.*.HDF5
del %OutputDrive%\%OutputDir%\3B-HHR.MS.MRG.3IMERG.*.XML
del %OutputDrive%\%OutputDir%\mpl_substitutename.bat
del %OutputDrive%\%OutputDir%\gpm_imerg_master.mpl
del %OutputDrive%\%OutputDir%\.urs_cookies
if exist %OutputDrive%\%OutputDir%\%JD% del %OutputDrive%\%OutputDir%\%JD%
del %OutputDrive%\%OutputDir%\Sum_%ldt%.mp*


:END
"%IlwDir%\ilwis.exe" -C closeall