@echo off

rem http://www.met.reading.ac.uk/~jeff/xconv/appx2.html
rem use is made of convsh1.91.exe
rem command line syntax convsh191 smdas22nc.tcl -i %1 -o test_tcl.nc


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*

copy "%InputDrive%\%InputDir%\S-HSAF-h14_%shortfilename1%_0000.grib.bz2" "%OutputDrive%\%OutputDir%\*.*"



if not exist "%OutputDrive%\%OutputDir%\S-HSAF-h14_%shortfilename1%_0000.grib.bz2" goto MESSAGE


echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h14_%shortfilename1%_0000.grib.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e "%OutputDrive%\%OutputDir%\S-HSAF-h14_%shortfilename1%_0000.grib.bz2"


"%UtilDir%\Conv\convsh191.exe" "%UtilDir%\Conv\smdas22nc.tcl" -i "%OutputDrive%\%OutputDir%\S-HSAF-h14_%shortfilename1%_0000.grib" -o S_HSAF_h14_%shortfilename1%.nc > nul

"%GdalDir%\gdal_translate" -ot Float64 -of ilwis NETCDF:"S_HSAF_h14_%shortfilename1%.nc":DZDT "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1t.mpr" 2>nul
"%GdalDir%\gdal_translate" -ot Float64 -of ilwis NETCDF:"S_HSAF_h14_%shortfilename1%.nc":ABSV "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2t.mpr" 2>nul
"%GdalDir%\gdal_translate" -ot Float64 -of ilwis NETCDF:"S_HSAF_h14_%shortfilename1%.nc":ABSD "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3t.mpr" 2>nul
"%GdalDir%\gdal_translate" -ot Float64 -of ilwis NETCDF:"S_HSAF_h14_%shortfilename1%.nc":RELV "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4t.mpr" 2>nul

rem set precision
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1tt'.mpr{dom=value;vr=0:1000000:1}:='%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1t'*1000
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2tt'.mpr{dom=value;vr=0:1000000:1}:='%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2t'*1000
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3tt'.mpr{dom=value;vr=0:1000000:1}:='%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3t'*1000
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4tt'.mpr{dom=value;vr=0:1000000:1}:='%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4t'*1000


rem create subset maps layer 1


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_east'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1tt',1,1,800,800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_west'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1tt',1,801,800,800)

rem add submap georef

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_east'.mpr '%UtilDir%\smdas2_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_west'.mpr '%UtilDir%\smdas2_west'

rem glue maps using georef 'sm_das2' global

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_1'.mpr:=MapGlue('%UtilDir%\sm_das2'.grf,'%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_west','%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1_east',replace)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_1'.mpr{dom=value;vr=0:100:0}:='%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_1'/1000.0000

rem create subset maps layer 2


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_east'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2tt',1,1,800,800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_west'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2tt',1,801,800,800)

rem add submap georef

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_east'.mpr '%UtilDir%\smdas2_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_west'.mpr '%UtilDir%\smdas2_west'

rem glue maps using georef 'sm_das2' global

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_2'.mpr:=MapGlue('%UtilDir%\sm_das2'.grf,'%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_west','%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2_east',replace)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_2'.mpr{dom=value;vr=0:100:0}:='%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_2'/1000.0000

rem create subset maps layer 3


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_east'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3tt',1,1,800,800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_west'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3tt',1,801,800,800)

rem add submap georef

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_east'.mpr '%UtilDir%\smdas2_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_west'.mpr '%UtilDir%\smdas2_west'

rem glue maps using georef 'sm_das2' global

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_3'.mpr:=MapGlue('%UtilDir%\sm_das2'.grf,'%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_west','%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3_east',replace)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_3'.mpr{dom=value;vr=0:100:0}:='%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_3'/1000.0000

rem create subset maps layer 4


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_east'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4tt',1,1,800,800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_west'.mpr{dom=value;vr=0:10000:1}:=MapSubMap('%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4tt',1,801,800,800)

rem add submap georef

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_east'.mpr '%UtilDir%\smdas2_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_west'.mpr '%UtilDir%\smdas2_west'

rem glue maps using georef 'sm_das2' global

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_4'.mpr:=MapGlue('%UtilDir%\sm_das2'.grf,'%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_west','%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4_east',replace)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_4'.mpr{dom=value;vr=0:100:0}:='%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_4'/1000.0000

rem create maplist of 4 sm_das maps

copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\mpl_substitutename.bat"
copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\sm_das2.mpl"

cmd /c mpl_substitutename.bat ______ _%shortfilename1%_ sm_das2.mpl > sm_das2_%shortfilename1%.mpl



rem delete obsolete objects

del "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_*t.mp*"
del "%OutputDrive%\%OutputDir%\SM_DAS2_%shortfilename1%_*t.grf"
del "%OutputDrive%\%OutputDir%\S-HSAF-h14_%shortfilename1%_0000.grib.bz2"
del "%OutputDrive%\%OutputDir%\S-HSAF-h14_%shortfilename1%_0000.grib"
del "%OutputDrive%\%OutputDir%\S_HSAF_h14_%shortfilename1%.nc"
del "%OutputDrive%\%OutputDir%\SM1_DAS2_%shortfilename1%_*.mp*
del "%OutputDrive%\%OutputDir%\mpl_substitutename.bat"
del "%OutputDrive%\%OutputDir%\sm_das2.mpl"

:END
"%IlwDir%\ilwis.exe" -C closeall