@echo off

rem HSAF h26 Soil Moisture import
rem file name expected S-HSAF-h26_2022063000_R01.nc
rem layer 200 not extracted at this moment

set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*

copy "%InputDrive%\%InputDir%\S-HSAF-h26_%shortfilename1%00_R01.nc" "%OutputDrive%\%OutputDir%\*.*"



if not exist "%OutputDrive%\%OutputDir%\S-HSAF-h26_%shortfilename1%00_R01.nc" goto MESSAGE


echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h26_%shortfilename1%00_R01.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


echo Importing layers
"%GdalDir%\gdal_translate" -of ilwis HDF5:"S-HSAF-h26_%shortfilename1%00_R01.nc"://var40 "%OutputDrive%\%OutputDir%\v40.mpr" 2>nul
"%GdalDir%\gdal_translate" -of ilwis HDF5:"S-HSAF-h26_%shortfilename1%00_R01.nc"://var41 "%OutputDrive%\%OutputDir%\v41.mpr" 2>nul
"%GdalDir%\gdal_translate" -of ilwis HDF5:"S-HSAF-h26_%shortfilename1%00_R01.nc"://var42 "%OutputDrive%\%OutputDir%\v42.mpr" 2>nul
"%GdalDir%\gdal_translate" -of ilwis HDF5:"S-HSAF-h26_%shortfilename1%00_R01.nc"://var43 "%OutputDrive%\%OutputDir%\v43.mpr" 2>nul


rem remove values for oceans - water
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v40_undef'.mpr{dom=value;vr=0:1:0.0001}:=iff('%OutputDrive%\%OutputDir%\v40' ge 0, '%OutputDrive%\%OutputDir%\v40',?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v41_undef'.mpr{dom=value;vr=0:1:0.0001}:=iff('%OutputDrive%\%OutputDir%\v41' ge 0, '%OutputDrive%\%OutputDir%\v41',?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v42_undef'.mpr{dom=value;vr=0:1:0.0001}:=iff('%OutputDrive%\%OutputDir%\v42' ge 0, '%OutputDrive%\%OutputDir%\v42',?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v43_undef'.mpr{dom=value;vr=0:1:0.0001}:=iff('%OutputDrive%\%OutputDir%\v43' ge 0, '%OutputDrive%\%OutputDir%\v43',?)

echo 'processing layer v40'
rem create subset maps layer v40
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v40_undef_east'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v40_undef',1,1,1801,1800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v40_undef_west'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v40_undef',1,1801,1801,1800)

rem add submap georef
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v40_undef_east'.mpr '%UtilDir%\h26_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v40_undef_west'.mpr '%UtilDir%\h26_west'

rem glue maps using georef 'sm_ascat' global
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h26_%shortfilename1%_v40'.mpr:=MapGlue('%UtilDir%\h26_world'.grf,'%OutputDrive%\%OutputDir%\v40_undef_west','%OutputDrive%\%OutputDir%\v40_undef_east',replace)


echo 'processing layer v41'
rem create subset maps layer v41
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v41_undef_east'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v41_undef',1,1,1801,1800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v41_undef_west'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v41_undef',1,1801,1801,1800)

rem add submap georef
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v41_undef_east'.mpr '%UtilDir%\h26_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v41_undef_west'.mpr '%UtilDir%\h26_west'

rem glue maps using georef 'sm_ascat' global
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h26_%shortfilename1%_v41'.mpr:=MapGlue('%UtilDir%\h26_world'.grf,'%OutputDrive%\%OutputDir%\v41_undef_west','%OutputDrive%\%OutputDir%\v41_undef_east',replace)

echo 'processing layer v42'
rem create subset maps layer v42
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v42_undef_east'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v42_undef',1,1,1801,1800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v42_undef_west'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v42_undef',1,1801,1801,1800)

rem add submap georef
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v42_undef_east'.mpr '%UtilDir%\h26_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v42_undef_west'.mpr '%UtilDir%\h26_west'

rem glue maps using georef 'sm_ascat' global
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h26_%shortfilename1%_v42'.mpr:=MapGlue('%UtilDir%\h26_world'.grf,'%OutputDrive%\%OutputDir%\v42_undef_west','%OutputDrive%\%OutputDir%\v42_undef_east',replace)

echo 'processing layer v43'
rem create subset maps layer v43
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v43_undef_east'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v43_undef',1,1,1801,1800)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\v43_undef_west'.mpr{dom=value;vr=0:1:0.0001}:=MapSubMap('%OutputDrive%\%OutputDir%\v43_undef',1,1801,1801,1800)

rem add submap georef
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v43_undef_east'.mpr '%UtilDir%\h26_east'
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\v43_undef_west'.mpr '%UtilDir%\h26_west'

rem glue maps using georef 'sm_ascat' global
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\h26_%shortfilename1%_v43'.mpr:=MapGlue('%UtilDir%\h26_world'.grf,'%OutputDrive%\%OutputDir%\v43_undef_west','%OutputDrive%\%OutputDir%\v43_undef_east',replace)



rem create maplist of 4 sm_ascat maps

copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\mpl_substitutename.bat"
copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\h26.mpl"

cmd /c mpl_substitutename.bat ________ _%shortfilename1%_ h26.mpl > h26_%shortfilename1%.mpl

rem delete obsolete objects

del "%OutputDrive%\%OutputDir%\v4*.mp*"
del S-HSAF-h26_%shortfilename1%00_R01.nc
del "%OutputDrive%\%OutputDir%\mpl_substitutename.bat"
del "%OutputDrive%\%OutputDir%\h26.mpl"

:END
"%IlwDir%\ilwis.exe" -C closeall