@echo off
echo Fire Detection and Monitoring African continent
set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_NAfr_%shortfilename1%.bz2" 
copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_SAfr_%shortfilename1%.bz2" 

if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_NAfr_%shortfilename1%.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_SAfr_%shortfilename1%.bz2" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_*Afr_%shortfilename1%.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_NAfr_%shortfilename1%.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FDeM_SAfr_%shortfilename1%.bz2


"%gdalDir%\gdal_translate.exe" -of ilwis -q S-LSA_-HDF5_LSASAF_MSG_FDeM_NAfr_%shortfilename1% "%OutputDrive%\%OutputDir%\nafr_%shortfilename1%" 
"%gdalDir%\gdal_translate.exe" -of ilwis -q S-LSA_-HDF5_LSASAF_MSG_FDeM_SAfr_%shortfilename1% "%OutputDrive%\%OutputDir%\safr_%shortfilename1%" 


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\nafr_%shortfilename1%.mpr %UtilDir%\lst_north;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\safr_%shortfilename1%.mpr %UtilDir%\lst_south;

echo.
Echo Continental composite is created, be patient
echo.

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\fFDeM_africa%shortfilename1%.mpr:=MapGlue('%UtilDir%\lst_whole'.grf,%OutputDrive%\%OutputDir%\nafr_%shortfilename1%,%OutputDrive%\%OutputDir%\safr_%shortfilename1%,replace)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\LSA_FDeM_africa%shortfilename1%.mpr:=MapSlicing('%OutputDrive%\%OutputDir%\fFDeM_africa%shortfilename1%','%utildir%\LSA_FDeM'.dom)



del fFDeM_africa*.mp*
del *.xml
del nafr_%shortfilename1%.*
del safr_%shortfilename1%.*
del S-LSA_-HDF5_LSASAF_MSG_FDeM_*.*



:END
"%IlwDir%\ilwis.exe" -C closeall