@echo off
echo Fire Risk Europe
set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200.bz2"
copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200.bz2" 
copy "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200.bz2"  


if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200.bz2" goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM.... F024 / F048 and F072" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo Not all required input files are available.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200.bz2
"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200.bz2

echo.
Echo Fire Weather Index Import
echo.
echo.
echo.


"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200"://FWI "%OutputDrive%\%OutputDir%\fwi_024_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200"://FWI "%OutputDrive%\%OutputDir%\fwi_048_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200"://FWI "%OutputDrive%\%OutputDir%\fwi_072_%shortfilename1%.mpr" 

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\fwi_024_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\fwi_048_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\fwi_072_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\FWI_024_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\fwi_024_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\fwi_024_%shortfilename1%'*0.01,?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\FWI_048_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\fwi_048_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\fwi_048_%shortfilename1%'*0.01,?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\FWI_072_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\fwi_072_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\fwi_072_%shortfilename1%'*0.01,?)

del fwi_0??_%shortfilename1%.mp*
del fwi_0??_%shortfilename1%.csy

echo.
echo.
Echo Daily Severity Rating Import
echo.
echo.
echo.


"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200"://DSR "%OutputDrive%\%OutputDir%\dsr_024_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200"://DSR "%OutputDrive%\%OutputDir%\dsr_048_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200"://DSR "%OutputDrive%\%OutputDir%\dsr_072_%shortfilename1%.mpr" 

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\dsr_024_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\dsr_048_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\dsr_072_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\DSR_024_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\dsr_024_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\dsr_024_%shortfilename1%'*0.01,?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\DSR_048_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\dsr_048_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\dsr_048_%shortfilename1%'*0.01,?)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\DSR_072_euro%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\dsr_072_%shortfilename1%' ge 0, '%OutputDrive%\%OutputDir%\dsr_072_%shortfilename1%'*0.01,?)

del dsr_0??_%shortfilename1%.mp*
del dsr_0??_%shortfilename1%.csy



echo.
echo.
Echo Fire Risk Import
echo.
echo.
echo.


"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F024_Euro_%shortfilename1%1200"://Risk "%OutputDrive%\%OutputDir%\Risk_024_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F048_Euro_%shortfilename1%1200"://Risk "%OutputDrive%\%OutputDir%\Risk_048_%shortfilename1%.mpr" 
"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-LSA_-HDF5_LSASAF_MSG_FRM-F072_Euro_%shortfilename1%1200"://Risk "%OutputDrive%\%OutputDir%\Risk_072_%shortfilename1%.mpr" 

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\Risk_024_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\Risk_048_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\Risk_072_%shortfilename1%'.mpr '%UtilDir%\lsa_euro';


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\LSA_Risk_024_euro%shortfilename1%'.mpr:=MapSlicing('%OutputDrive%\%OutputDir%\Risk_024_%shortfilename1%','%utildir%\LSA_FRM_Risk'.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\LSA_Risk_048_euro%shortfilename1%'.mpr:=MapSlicing('%OutputDrive%\%OutputDir%\Risk_048_%shortfilename1%','%utildir%\LSA_FRM_Risk'.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\LSA_Risk_072_euro%shortfilename1%'.mpr:=MapSlicing('%OutputDrive%\%OutputDir%\Risk_072_%shortfilename1%','%utildir%\LSA_FRM_Risk'.dom)

del risk_0??_%shortfilename1%.mp*
del risk_0??_%shortfilename1%.csy



del S-LSA_-HDF5_LSASAF_MSG_FRM-F0??_Euro_%shortfilename1%1200.bz2
del S-LSA_-HDF5_LSASAF_MSG_FRM-F0??_Euro_%shortfilename1%1200

:END
"%IlwDir%\ilwis.exe" -C closeall