@echo off
echo MPEF Atmospheric Motion Vector BUFR Import and Processing
echo Note that import can take some time as large number of record need to be processed
echo Be patient as various columns in a table are being calculated
echo After routine has completed display the mapview
echo For quick visualization of the AMV file use BUFRDisplay
echo Relevant coordinate variables are: 20-latitude (code 5001), 19-longitude (code 6001)
echo Relevant parameters are: 29-Pressure (code 7004), 30-Wind_direction (code 11001), 31-Wind_speed (code 11002) and 34-Temperature (code 12001)
echo.
echo.
rem new file name convention W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_20221027023000_2.bin


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_%shortfilename1%00_2.bin" %OutputDrive%\%OutputDir%\*.*

if exist "%OutputDrive%\%OutputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_%shortfilename1%00_2.bin" GOTO START

:START1
if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_%shortfilename1%00_2.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_%shortfilename1%00_2.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

ren "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+AMV_C_EUMG_%shortfilename1%00_2.bin" AMV%shortfilename1%


copy AMV%shortfilename1% "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe AMV%shortfilename1% -oddump.csv >mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\AMV%shortfilename1%"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

rem columns are X, Y, Pressure, Winddir_Temp, Windspeed, Temperature
java ConvertCSV 20 19 29 30 31 34 < dump2.csv > dump3.csv 

cls
echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS and calculating additional attributes
echo Be patient and wait till mapview is displayed
echo.

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\amv_imp%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-90:180:0.00001}),Y(value.dom{-90:90:0.00001}),Pressure_Pa(value.dom{0:1000000:0.1}),winddir_temp(value.dom{0:360:0.1}),WindSpeed(value.dom{0:1000:0.1}),Temperature(value.dom{0:1000:0.1}));

"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\amv_imp%shortfilename1%.tbt WindDirection{dom=value;vr=0:360:0.01}:=iff(winddir_temp gt 180,180-(360-winddir_temp),iff(winddir_temp le 180, winddir_temp+180, winddir_temp));
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\amv_imp%shortfilename1%.tbt approx_elev{dom=value;vr=0:25000:0.01}:=(-1/0.0001184*(ln(pressure_Pa/101325)));

rem conversion to pointmap
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\amv_imp%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\amv_imp%shortfilename1%,LatlonWGS84);

rem Display results


copy "%UtilDir%\mpl_substitutename.bat" >NUL
copy "%UtilDir%\amv_iodc_386.mpv" >NUL
cmd /c mpl_substitutename.bat ____ %shortfilename1% amv_iodc_386.mpv > amvIODC%shortfilename1%.mpv

rem display imported data - ilwis should be active / open
"%UtilDir%\DDEClient.exe" "open %OutputDrive%\%OutputDir%\amvIODC%shortfilename1%.mpv -noask"

del amv_iodc_386.mpv

:END

del AMV%shortfilename1%
del dump*.csv
del ConvertCSV.class
del mpl_substitutename.bat

"%IlwDir%\ilwis.exe" -C closeall