@echo off
echo Extract MPEF MSG-based fire product (FIRG), G=Grid
rem new filename convention: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+FIRG_C_EUMG_20221027003000_2.bin
echo Grid is converted to point

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDrive%\%OutputDir%*



copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+FIRG_C_EUMG_%shortfilename1%00_2.bin" 

if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+FIRG_C_EUMG_%shortfilename1%00_2.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+FIRG_C_EUMG_%shortfilename1%00_2.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
ren "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+FIRG_C_EUMG_%shortfilename1%00_2.bin" "firg_%shortfilename1%.bin"
"%GDALDir%\gdal_translate" -of ilwis "firg_%shortfilename1%.bin" firg_%shortfilename1%.mpr


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\temp1':=iff('%OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_1'=1,1,iff('%OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_1'=2,2,?))
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\temp2':=iff('%OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_2' gt 0,'%OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_2',?)

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\temp1.mpr '%UtilDir%\firg_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\temp2.mpr '%UtilDir%\firg_IODC'.grf

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\firg_b1_IODC%shortfilename1%'.mpp:=PointMapFromRas('%OutputDrive%\%OutputDir%\temp1')
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\firg_b2_IODC%shortfilename1%'.mpp:=PointMapFromRas('%OutputDrive%\%OutputDir%\temp2')



del %OutputDrive%\%OutputDir%\firg_%shortfilename1%.mpl
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%.grf
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%.csy
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_?.mpr
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%_band_?.mp#
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%.mpr.au*
del %OutputDrive%\%OutputDir%\temp1.mp*
del %OutputDrive%\%OutputDir%\temp2.mp*
del %OutputDrive%\%OutputDir%\firg_%shortfilename1%.bin


:END
"%IlwDir%\ilwis.exe" -C closeall