@echo off
echo NDVI-import
echo. 
echo output maps NDVI-Min, NDVI-Max, NDVI-Mean 
echo for NDVI min, max and mean if input less 100 map divided by 100
echo NDVI-accum not processed
rem file name convention is L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-201701011200-__


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__*.*" 

if not exist "%OutputDrive%\%OutputDir%\L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__*.*" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__*.*" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

"%UtilDir%\joinmsg.exe" "L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

rename "L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__.xyz" NDVI%shortfilename1%.hdf

"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImax "%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1%"
"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImean "%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1%"
"%gdaldir%\gdal_translate.exe" -of ILWIS HDF5:"NDVI%shortfilename1%.hdf"://NDVImin "%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1%"



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\NDVImax_IODC%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1% le 100,%OutputDrive%\%OutputDir%\tNDVImax%shortfilename1%/100,?);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\NDVImean_IODC%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1% le 100,%OutputDrive%\%OutputDir%\tNDVImean%shortfilename1%/100,?);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\NDVImin_IODC%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1% le 100,%OutputDrive%\%OutputDir%\tNDVImin%shortfilename1%/100,?);

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\NDVImax_IODC%shortfilename1%.mpr %UtilDir%\msg_IODC;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\NDVImean_IODC%shortfilename1%.mpr %UtilDir%\msg_IODC;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\NDVImin_IODC%shortfilename1%.mpr %UtilDir%\msg_IODC;



del "tndvimax%shortfilename1%".mp*
del "tndvimin%shortfilename1%".mp*
del "tndvimean%shortfilename1%".mp*

rem del "tndvimax%shortfilename1%".csy
rem del "tndvimin%shortfilename1%".csy
rem del "tndvimean%shortfilename1%".csy



del ndvi%shortfilename1%.hdf
del "L-000-MSG1__-MPEF_IODC___-NDVI_____-000001___-%shortfilename1%-__*.*"

:END
"%IlwDir%\ilwis.exe" -C closeall