@echo off
echo Optimal Cloud Analysis-import
echo 12 output layers
echo Non clouded areas are assigned undefined - not a value
echo Layers at full MSG resolution - extraction and further pre-processing takes some time!
echo Temporal resolution 1 hr
rem new file name convention used is W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+OCAE_C_EUMG_20221027050000_2.bin



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+OCAE_C_EUMG_%shortfilename1%00_2.bin"  


if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+OCAE_C_EUMG_%shortfilename1%00_2.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+OCAE_C_EUMG_%shortfilename1%00_2.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START
rename "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET09+OCAE_C_EUMG_%shortfilename1%00_2.bin" oca%shortfilename1%.grib
"%gdalDir%\gdal_translate.exe" -of ILWIS "%OutputDrive%\%OutputDir%\oca%shortfilename1%.grib" "%OutputDrive%\%OutputDir%\OCAt_IODC_%shortfilename1%"
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%.mpl:=maplistcalculate("iff(@1 ne 9999,@1,?)",0,11,0,OCAt_IODC_%shortfilename1%.mpl)


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_01.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_02.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_03.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_04.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_05.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_06.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_07.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_08.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_09.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_10.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_11.mpr '%UtilDir%\msg2_IODC'.grf
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\OCA_IODC%shortfilename1%_12.mpr '%UtilDir%\msg2_IODC'.grf

del OCA_IODC%shortfilename1%.mpl


copy "%UtilDir%\mpl_substitutename.bat" >NUL
copy "%UtilDir%\maps\OCA_IODC.mpl" >NUL

cmd /c mpl_substitutename.bat ____ _IODC%shortfilename1%_ OCA_IODC.mpl > OCA_IODC%shortfilename1%.mpl


del oca%shortfilename1%.grib
del OCAt_IODC_%shortfilename1%_band_*.mp*
del OCAt_IODC_%shortfilename1%.mpl
del OCAt_IODC_%shortfilename1%.csy
del OCAt_IODC_%shortfilename1%.grf
del mpl_substitutename.bat
del OCA_IODC.mpl
del OCAt_IODC_%shortfilename1%.aux.xml

:END
"%IlwDir%\ilwis.exe" -C closeall