@echo off 
rem files available in GEONETCast:
echo METOP AVHRR ABC: METOP AVHRR (METOP A - MO2) METOP AVHRR (METOP B - MO1) and METOP AVHRR (METOP C - MO3)
echo sample file name AVHR_xxx_1B_M02_20140805101003Z_20140805101303Z_N_O_20140805114320Z.bz2
echo each file is a 3 minutes scan full resolution image (2048 columns by 1080 lines) 
echo full filename.extension is required as input
echo file name extension is .BZ2
echo for daytime images only - reflectance channels 1, 2, 3a are used


set longfilename=%1
set shortfilename1=%longfilename%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*
echo.
echo.
echo %shortfilename1%

copy "%inputDrive%\%InputDir%\%shortfilename1%" 


echo off
if not exist "%OutputDrive%\%OutputDir%\%shortfilename1%"  goto MESSAGE
echo The file(s) "%OutputDrive%\%OutputDir%\%shortfilename1%" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your File Name settings
echo Your current File Name used is %shortfilename1%
echo Data is retrieved from %inputDrive%\%InputDir%\



pause

GOTO END

:START

rem import data in ilwis format

"%UtilDir%\7z" e "%OutputDrive%\%OutputDir%\%shortfilename1%"


rem sample original input file name AVHR_xxx_1B_M02_20200323084603Z_20200323084903Z_N_O_20200323102045Z.bz2
set shortfilename2=%shortfilename1:~0,4%%shortfilename1:~11,17%
rem rename %shortfilename1% %shortfilename2% 

echo %shortfilename1%
echo %shortfilename2%


echo.
echo AVHRR channels 1, 2 and 3a are imported
java -jar "%UtilDir%\AVHRR_Importer.jar" -of ilwis "%shortfilename1:~0,-4%" "%OutputDrive%\%OutputDir%\%shortfilename2%"


echo.


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_red'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\%shortfilename2%_reflec_3a'.mpr,0.01:6.67,image.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_green'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\%shortfilename2%_reflec_2'.mpr,0.09:18.33,image.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_blue'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\%shortfilename2%_reflec_1'.mpr,0.06:6.67,image.dom)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_red_add'.mpr{dom=image.dom;vr=0:255}:=iff('%OutputDrive%\%OutputDir%\metop_red' le 200,'%OutputDrive%\%OutputDir%\metop_red'+55,255)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_green_add'.mpr{dom=image.dom;vr=0:255}:=iff('%OutputDrive%\%OutputDir%\metop_green' le 200,'%OutputDrive%\%OutputDir%\metop_green'+55,255)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_blue_add'.mpr{dom=image.dom;vr=0:255}:=iff('%OutputDrive%\%OutputDir%\metop_blue' le 200,'%OutputDrive%\%OutputDir%\metop_blue'+55,255)




"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\%shortfilename2%rgb'.mpr:=MapColorComp24Linear(mlist('%OutputDrive%\%OutputDir%\metop_red_add','%OutputDrive%\%OutputDir%\metop_green_add','%OutputDrive%\%OutputDir%\metop_blue_add'),0.000000:255.000000,0.000000:255.000000,0.000000:255.000000)


rem delete obsolete objects

del "%shortfilename2%_*.*"
del %longfilename%
del metop_red.*
del metop_green.*
del metop_blue.*
del metop_red_add.*
del metop_green_add.*
del metop_blue_add.*
del %shortfilename1:~0,-4%


:END
"%IlwDir%\ilwis.exe" -C closeall