@echo off 
echo Cloud Maks Import
echo Retrieve cloud, Dust and Volcanic mask
echo From Nowcasting SAF
echo For full MSG disk
rem Filename convention SAFNWC_MSG3_CMa__201404170930_FES_________.h5



set longfilename=%1
set shortfilename1=%longfilename:~0,12%

set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\SAFNWC_MSG?_CMa__%shortfilename1%_FES_________.h5" "%OutputDrive%\%OutputDir%\*.*"


if exist "%InputDrive%\%InputDir%\SAFNWC_MSG2_CMa__%shortfilename1%_FES_________.h5" GOTO START
set MSG_number=3
if exist "%InputDrive%\%InputDir%\SAFNWC_MSG3_CMa__%shortfilename1%_FES_________.h5" GOTO START
set MSG_number=4

:START1
if not exist "%OutputDrive%\%OutputDir%\SAFNWC_MSG%MSG_number:~0,1%_CMa__%shortfilename1%_FES_________.h5" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\SAFNWC_MSG%MSG_number:~0,1%_CMa__%shortfilename1%_FES_________.h5" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START
echo.
rem Cloud Mask
echo Retrieve Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CMa__%shortfilename1%_FES_________.h5"://CMa %OutputDrive%\%OutputDir%\NWC_CMa_mask_v_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_CMa_mask_v_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_mask_cl_%shortfilename1%'.mpr{dom=nwc_cma_h5.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\NWC_CMa_mask_v_%shortfilename1%','%utildir%\nwc_cma_h5'.dom)

del "%OutputDrive%\%OutputDir%\NWC_CMa_mask_v_%shortfilename1%.mpr.aux.xml"


echo.
rem Dust Cloud Mask
echo Retrieve Dust Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CMa__%shortfilename1%_FES_________.h5"://CMa_DUST %OutputDrive%\%OutputDir%\NWC_CMa_dust_v_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_CMa_dust_v_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_dust_cl_%shortfilename1%'.mpr{dom=nwc_dust_vol_h5.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\NWC_CMa_dust_v_%shortfilename1%','%utildir%\nwc_dust_vol_h5'.dom)

del "%OutputDrive%\%OutputDir%\NWC_CMa_dust_v_%shortfilename1%.mpr.aux.xml"

echo.
rem Volcanic Cloud Mask
echo Retrieve Volcanic Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CMa__%shortfilename1%_FES_________.h5"://CMa_VOLCANIC %OutputDrive%\%OutputDir%\NWC_CMa_vol_v_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_CMa_vol_v_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_vol_cl_%shortfilename1%'.mpr{dom=nwc_dust_vol_h5.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\NWC_CMa_vol_v_%shortfilename1%','%utildir%\nwc_dust_vol_h5'.dom)

del "%OutputDrive%\%OutputDir%\NWC_CMa_vol_v_%shortfilename1%.mpr.aux.xml"


del "%OutputDrive%\%OutputDir%\SAFNWC_MSG*_CMa__%shortfilename1%_FES_________.h5"
:END
"%IlwDir%\ilwis.exe" -C closeall