@echo off 
echo Phase and Type of Cloud Cell Import
echo From Nowcasting SAF
echo For full MSG disk 0 degree
echo Only hourly MSG temporal resolution
rem Filename convention S_NWC_RDT-CW_MSG4_global-VISIR_20190618T094500Z.nc
rem layer MapCellCatType is extracted - subdataset 30

rem MapCellCatType comment=
rem 0:Non_convective 
rem 1:Convective_triggering 
rem 2:Convective_triggering_from_split 
rem 3:Convective_growing 
rem 4:Convective_mature 
rem 5:OvershootingTop_mature 
rem 6:Convective_decaying 
rem 7:Electric_triggering 
rem 8:Electric_triggering_from_split 
rem 9:Electric_growing 
rem 10:Electric_mature 
rem 11:Electric_decaying 
rem 12:HighRainRate_triggering 
rem 13:HighRainRate_triggering_from_split 
rem 14:HighRainRate_growing 
rem 15:HighRainRate_mature 
rem 16:HighRainRate_decaying 
rem 17:HighSeverity_triggering 
rem 18:HighSeverity_triggering_from_split 
rem 19:HighSeverity_growing 
rem 20:HighSeverity_mature 
rem 21:HighSeverity_decaying

set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\S_NWC_RDT-CW_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" "%OutputDrive%\%OutputDir%\*.*"

set MSG_number=2
if exist "%InputDrive%\%InputDir%\S_NWC_RDT-CW_MSG2_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=3
if exist "%InputDrive%\%InputDir%\S_NWC_RDT-CW_MSG3_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=4


:START
if not exist "%OutputDrive%\%OutputDir%\S_NWC_RDT-CW_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S_NWC_RDT-CW_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START1

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%%shortfilename2%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START1

echo.
rem Phase and Type of Cloud Cell Import
echo.

ren S_NWC_RDT-CW_MSG?_global-VISIR_%shortfilename1%T%shortfilename2%00Z.nc NWC_RDT_%shortfilename1%%shortfilename2%.nc
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"NWC_RDT_%shortfilename1%%shortfilename2%.nc"://MapCellCatType %OutputDrive%\%OutputDir%\NWC_RDT_temp_%shortfilename1%%shortfilename2%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_RDT_temp_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\msg_0degree_3km'.grf; 

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_RDT_type_%shortfilename1%%shortfilename2%'.mpr{dom=nwc_rdt.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\NWC_RDT_temp_%shortfilename1%%shortfilename2%','%utildir%\nwc_rdt'.dom)

del "%OutputDrive%\%OutputDir%\NWC_RDT_temp_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\NWC_RDT_temp_%shortfilename1%%shortfilename2%.mp*"
del "%OutputDrive%\%OutputDir%\NWC_RDT_%shortfilename1%%shortfilename2%.nc"

:END
"%IlwDir%\ilwis.exe" -C closeall