@echo off 
echo Chlorophyll-a concentration in sea water as measured by the MODIS sensor
echo mass concentration of chlorophyll in sea water
echo units: mg m^-3
echo maximum value limited to 250 mg m^-3
echo filename convention PML_SSomalia_MODIS_oc_refined_20130817092000.nc.bz2


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the timestamp of your data file

pause

GOTO END

:START

"%UtilDir%\7z" e PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc":chlor_a %OutputDrive%\%OutputDir%\tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.mpr %UtilDir%\pml_modis_SSomalia.grf;
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.mpr{dom=value;vr=0.000:250.000:0.00001}:=iff(%OutputDrive%\%OutputDir%\tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a ge 0,tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a,?);

del tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.mp*
del tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.grf
del tPML_SSomalia_MODIS_oc_refined_%shortfilename1%_chlor_a.csy
del PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc.bz2
del PML_SSomalia_MODIS_oc_refined_%shortfilename1%00.nc




:END
"%IlwDir%\ilwis.exe" -C closeall

