@echo off 
echo TAMSAT RFE monthly accumulated rainfall product (rainfall in mm)
echo imported from netCDF, post march 2011
echo Current file name convention rfe2020_10.v3.1.nc



set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set shortfilename2=%longfilename:~4,2%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo rfe%shortfilename1%_%shortfilename2%
echo *%outputDrive%\%OutputDir%*

copy %inputDrive%\%InputDir%\rfe%shortfilename1%_%shortfilename2%.v*.nc %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\rfe%shortfilename1%_%shortfilename2%.v*.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\rfe%shortfilename1%_%shortfilename2%.v*.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
ren rfe%shortfilename1%_%shortfilename2%.v*.nc rfe%shortfilename1%_%shortfilename2%.nc
"%GdalDir%\gdal_translate.exe" -of ilwis  HDF5:"rfe%shortfilename1%_%shortfilename2%.nc"://rfe %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%a.mpr

copy "%utildir%\maps\rfeland_mask1.zip"

"%utildir%\7z" e rfeland_mask1.zip
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%a.mpr %utildir%\rfe_nc
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%:=iff(%OutputDrive%\%OutputDir%\africaland_mask1=1 and %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%a=0,0,%OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%a.mpr)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%.mpr %utildir%\rfe_nc

del rfe%shortfilename1%_%shortfilename2%.nc
rem del rfe%shortfilename1%%shortfilename2%a.grf
del rfeland_mask1.*
del rfe%shortfilename1%%shortfilename2%a.mp*
del africaland_mask1.*


:END
"%IlwDir%\ilwis.exe" -C closeall