@echo off
rem Import GPM Level 2 rainfall (mm/hr)
rem As 5 minutes orbit files, combined to one hour
rem gdal import as xyz ascii, for lat, lon and surface rain from H5 file

rem old file name convention 2A.GPM.GMI.GPROF2014v1-4.20150915-S133140-E133638.V03E.RT-H5
rem new file name convention 2A.GPM.GMI.GPROF2017v1.20190202-S224639-E225137.V05B.RT-H5
rem new file name convention 2A.GPM.GMI.GPROF2021v1.20220630-S112723-E113221.V07A.RT-H5


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,2%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo set InputDrive=%2>inputparam.bat
echo set InputDir=%3>>inputparam.bat
echo set OutputDrive=%4>>inputparam.bat
echo set OutputDir=%5>>inputparam.bat
echo set GdalDir=%6>>inputparam.bat
echo set IlwDir=%7>>inputparam.bat
echo set UtilDir=%8>>inputparam.bat

echo *%OutputDrive%\%OutputDir%*

copy "%inputDrive%\%inputDir%\2A.GPM.GMI.GPROF20*v1.%shortfilename1%-S%shortfilename2%*"
copy "%IlwDir%\Extensions\GEONETCast-Toolbox\toolbox_batchroutines\gpm_import_orbit.bat"


if not exist "%OutputDrive%\%OutputDir%\2A.GPM.GMI.GPROF20*v1.%shortfilename1%-S%shortfilename2%*" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\2A.GPM.GMI.GPROF20*v1.%shortfilename1%-S%shortfilename2%*" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input files are not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

for %%j in (2A.GPM.GMI.GPROF*-H5) do cmd /c gpm_import_orbit.bat %%j

copy "%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%*.txt" "%OutputDrive%\%OutputDir%\gpmhour.txt"


cls
echo.
echo Processing all 5 minutes files and creating 1 hour orbit stack
echo Processing will take some time - be patient
echo.


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%'.tbt:=table(gpmhour.txt,Comma,Convert,none,c1(value.dom{0.5:220.5:0.1}),c2(value.dom{0.5:159.5:0.1}),x(value.dom{-180:180:1e-006}),y(value.dom{-70:70:1e-006}),p(value.dom{-9999:500:0.001}),p_more01(value.dom{0:500:0.001}))

"%IlwDir%\ilwis.exe" -C tabcalc '%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%'.tbt p_more01:=iff(p ge 0.1,p,?)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%'.mpp:=PointMapFromTable(GPM_%shortfilename1%_%shortfilename2%,LatlonWGS84,p_more01)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%'.mpr{dom=value;vr=0:750:0.000001}:=MapRasterizePoint(GPM_%shortfilename1%_%shortfilename2%,'%utilDir%\gpm_2_5min'.grf,2)

del "%OutputDrive%\%OutputDir%\gpmhour.txt"
del "%OutputDrive%\%OutputDir%\inputparam.bat"
del "%OutputDrive%\%OutputDir%\gpm_import_orbit.bat"
del "%OutputDrive%\%OutputDir%\GPM_%shortfilename1%_%shortfilename2%*.txt"

:END