@echo off
echo Extract SMOS Soil Moisture
echo units = "m3m-3";
echo all products for a given day are retrieved and processed
echo file name convention is W_XX-ESA,SMOS,NRTNN_C_LEMM_20190122065625_20190122045125_20190122050018_o_v200_l2sm.nc
echo new file name convention is W_XX-ESA,SMOS,NRTNN_C_LEMM_20220701071729_20220701050842_20220701063842_o_v300_l2sm.nc
rem note file name format for date
rem second date string is used, as this is the start of scan
rem see string example used for copy  W_XX-ESA,SMOS,NRTNN_C_LEMM_??????????????_??????????????_*_o_v300_l2sm.nc

echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~0,4%
set shortfilename3=%longfilename:~4,2%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

echo set InputDrive=%2>inputparam.bat
echo set InputDir=%3>>inputparam.bat
echo set OutputDrive=%4>>inputparam.bat
echo set OutputDir=%5>>inputparam.bat
echo set gdalDir=%6>>inputparam.bat
echo set IlwDir=%7>>inputparam.bat
echo set UtilDir=%8>>inputparam.bat


@echo on

copy "%InputDrive%\%InputDir%\W_XX-ESA,SMOS,NRTNN_C_LEMM_??????????????_%shortfilename1%??????_*_o_v300_l2sm.nc" 

echo off
if not exist "%OutputDrive%\%OutputDir%\W_XX-ESA,SMOS,NRTNN_C_LEMM_??????????????_%shortfilename1%??????_*_o_v300_l2sm.nc"  goto MESSAGE
echo The file(s) "SMOS_%shortfilename1%_sm.nc" has been retrieved and transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from %InputDrive%\%InputDir%\
echo Check also manually if the data exists on the archive (see above)


pause

GOTO END

:START
echo off

copy %IlwDir%\Extensions\Geonetcast-Toolbox\toolbox_batchroutines\smos_import_day_loop.bat

ren "W_XX-ESA,SMOS,NRTNN_C_LEMM_??????????????_??????????????_??????????????_o_v300_l2sm.nc" smos_ESA_SMOS_NRTNN_C_LEMM_??????????????_??????????????_??????????????_o_v300_l2sm.nc

cmd/c for %%j in ("smos_ESA_SMOS_NRTNN_C_LEMM_*.nc") do cmd/c smos_import_day_loop.bat %%j

del "%OutputDrive%\%OutputDir%\smos_import_day_loop.bat" 


:END

del "%OutputDrive%\%OutputDir%\inputparam.bat"


"%IlwDir%\ilwis.exe" -C closeall
