@echo off
echo Extract NOAA STAR 
echo Archive used is ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/

echo After extraction file name is VHP.G04.C07.npp.P2020050.VH.VHI.tif, VHP.G04.C07.npp.P2020050.VH.VCI.tif and VHP.G04.C07.npp.P1981035.VH.TCI.tif	
echo Data extracted for a week numbered 001 to 052!
echo Weekly time interval!
echo NOAA 19 (NP) - AVHRR instrument used
echo processed are TCI, VCI and VHI


rem file name convention VHP.G04.C07.npp.P2020050.VH.VHI.tif, VHP.G04.C07.npp.P2020050.VH.VCI.tif and VHP.G04.C07.npp.P1981035.VH.TCI.tif


echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set shortfilename2=%longfilename:~4,3%
set OutputDrive=%4
set OutputDir=%5
set GdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.





"%UtilDir%\wget\wget.exe" ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VHI.tif
"%UtilDir%\wget\wget.exe" ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VCI.tif
"%UtilDir%\wget\wget.exe" ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.TCI.tif

echo off
if not exist "%OutputDrive%\%OutputDir%\VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VHI.tif"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VCI.tif"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.TCI.tif"  goto MESSAGE
echo The file(s) "VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.SM" have been retrieved and transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%%shortfilename2%
echo Data is retrieved from ftp://ftp.star.nesdis.noaa.gov/pub/corp/scsb/wguo/data/Blended_VH_4km/geo_TIFF/
echo Check also manually if the data exists on ftp archive (see link above)
echo Internet has a transient nature - addresses might not be valid or has changed after some time!


pause

GOTO END

:START
ren VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VHI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.tif
ren VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.VCI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.tif
ren VHP.G04.C07.npp.P%shortfilename1%%shortfilename2%.VH.TCI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.tif

"%GdalDir%\gdal_translate.exe" -of ilwis STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.tif STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.mpr

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMVHI:=iff(%OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI ge 0, %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMVCI:=iff(%OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI ge 0, %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMTCI:=iff(%OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI ge 0, %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI,?)


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMVHI.mpr %utildir%\star_vhp.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMVCI.mpr %utildir%\star_vhp.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\STAR_VHP_%shortfilename1%%shortfilename2%_SMTCI.mpr %utildir%\star_vhp.grf;

del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.tif
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.tif
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.tif  

del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.mp*
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.mp*
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.mp*

del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.grf
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VHI.csy

del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.grf
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_VCI.csy

del STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.grf
del STAR_VHP_%shortfilename1%%shortfilename2%_SM_TCI.csy



:END
"%IlwDir%\ilwis.exe" -C closeall