function CustomInputBox([string] $message1, [string] $output_box,[string] $message2, [string] $ULX, [string] $message3, [string] $ULY, [string] $message4, [string] $LRX, [string] $message5, [string] $LRY, [string] $message6, [string] $NoData) 
{
 [void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing")
 [void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms") 
 $userForm = New-Object System.Windows.Forms.Form
 $userForm.Text = "Conversion from ILWIS to GEOTIFF as Float32 - including GeoLocation and NoData Value"
 $userForm.Size = New-Object System.Drawing.Size(500,390)
 $userForm.StartPosition = "CenterScreen"
     $userForm.AutoSize = $False
     $userForm.MinimizeBox = $False
     $userForm.MaximizeBox = $False
     $userForm.SizeGripStyle= "Hide"
     $userForm.WindowState = "Normal"
     $userForm.FormBorderStyle="Fixed3D"
     
 $Script:retValues = @()

 $OKButton = New-Object System.Windows.Forms.Button
 $OKButton.Location = New-Object System.Drawing.Size(320,305)
 $OKButton.Size = New-Object System.Drawing.Size(75,23)
 $OKButton.Text = "OK"
 $OKButton.Add_Click({
            $Script:retValues +=$objTextBox1.Text; 
            $Script:retValues +=$objTextBox2.Text;
            $Script:retValues +=$objTextBox3.Text;
            $Script:retValues +=$objTextBox4.Text;
            $Script:retValues +=$objTextBox5.Text;
            $Script:retValues +=$objTextBox6.Text;$userForm.Close()})
 $userForm.Controls.Add($OKButton)
 
 $CancelButton = New-Object System.Windows.Forms.Button
 $CancelButton.Location = New-Object System.Drawing.Size(400,305)
 $CancelButton.Size = New-Object System.Drawing.Size(75,23)
 $CancelButton.Text = "Cancel"
 $CancelButton.Add_Click({$userForm.Close()})
 $userForm.Controls.Add($CancelButton)
  
  
  
 $userLabel1 = New-Object System.Windows.Forms.Label
 $userLabel1.Location = New-Object System.Drawing.Size(10,67)
 $userLabel1.Size = New-Object System.Drawing.Size(200,15)
 $userLabel1.Text = "$message1"
 $userForm.Controls.Add($userLabel1) 
 
 $objTextBox1 = New-Object System.Windows.Forms.TextBox
 $objTextBox1.Location = New-Object System.Drawing.Size(225,60)
 $objTextBox1.Size = New-Object System.Drawing.Size(250,15)
 $objTextBox1.Text="$output_box"
 $userForm.Controls.Add($objTextBox1)
   
   
 $userLabel2 = New-Object System.Windows.Forms.Label
 $userLabel2.Location = New-Object System.Drawing.Size(10,97)
 $userLabel2.Size = New-Object System.Drawing.Size(250,15)
 $userLabel2.Text = "$message2"
 $userForm.Controls.Add($userLabel2) 
 
 $objTextBox2 = New-Object System.Windows.Forms.TextBox
 $objTextBox2.Location = New-Object System.Drawing.Size(415,95)
 $objTextBox2.Size = New-Object System.Drawing.Size(60,15)
 $objTextBox2.Text="$ULX"
 $userForm.Controls.Add($objTextBox2)
 
 $userLabel3 = New-Object System.Windows.Forms.Label
 $userLabel3.Location = New-Object System.Drawing.Size(10,133)
 $userLabel3.Size = New-Object System.Drawing.Size(250,15)
 $userLabel3.Text = "$message3"
 $userForm.Controls.Add($userLabel3) 
 
 $objTextBox3 = New-Object System.Windows.Forms.TextBox
 $objTextBox3.Location = New-Object System.Drawing.Size(415,130)
 $objTextBox3.Size = New-Object System.Drawing.Size(60,15)
 $objTextBox3.Text="$ULY"
 $userForm.Controls.Add($objTextBox3)
 
 $userLabel4 = New-Object System.Windows.Forms.Label
 $userLabel4.Location = New-Object System.Drawing.Size(10,168)
 $userLabel4.Size = New-Object System.Drawing.Size(250,15)
 $userLabel4.Text = "$message4"
 $userForm.Controls.Add($userLabel4) 
 
 $objTextBox4 = New-Object System.Windows.Forms.TextBox
 $objTextBox4.Location = New-Object System.Drawing.Size(415,165)
 $objTextBox4.Size = New-Object System.Drawing.Size(60,15)
 $objTextBox4.Text = "$LRX"
 $userForm.Controls.Add($objTextBox4)
 
 $userLabel5 = New-Object System.Windows.Forms.Label
 $userLabel5.Location = New-Object System.Drawing.Size(10,197)
 $userLabel5.Size = New-Object System.Drawing.Size(250,15)
 $userLabel5.Text = "$message5"
 $userForm.Controls.Add($userLabel5) 
 
 $objTextBox5 = New-Object System.Windows.Forms.TextBox
 $objTextBox5.Location = New-Object System.Drawing.Size(415,200)
 $objTextBox5.Size = New-Object System.Drawing.Size(60,15)
 $objTextBox5.Text = "$LRY"
 $userForm.Controls.Add($objTextBox5)
 
 $userLabel6 = New-Object System.Windows.Forms.Label
 $userLabel6.Location = New-Object System.Drawing.Size(10,232)
 $userLabel6.Size = New-Object System.Drawing.Size(250,15)
 $userLabel6.Text = "$message6"
 $userForm.Controls.Add($userLabel6) 
 
 $objTextBox6 = New-Object System.Windows.Forms.TextBox
 $objTextBox6.Location = New-Object System.Drawing.Size(415,235)
 $objTextBox6.Size = New-Object System.Drawing.Size(60,15)
 $objTextBox6.Text = "$NoData"
 $userForm.Controls.Add($objTextBox6)
   
     $userForm.Topmost = $True
     $userForm.Opacity = 1.0
     $userForm.ShowIcon = $False
     $userForm.Add_Shown({$userForm.Activate()})
 [void] $userForm.ShowDialog()
  return $Script:retValues
  

}

$retValues = CustomInputBox "Specify output file name (no extension):" "" "Specify Upper Left X (ULX in degree.decimal):" "" "Specify Upper Left Y (ULY in degree.decimal):" "" "Specify Lower Right X (LRX in degree.decimal):" "" "Specify Lower Right Y (LRY in degree.decimal):" "" "Specify NoData Value:" ""


if ( $retValues -ne $null ) 

{
echo "set output_file=$($retValues[0])"  | out-file 'st_importtif.bat' -append -Encoding ASCII
echo "set ULX=$($retValues[1])" | out-file 'st_importtif.bat' -append -Encoding ASCII
echo "set ULY=$($retValues[2])" | out-file 'st_importtif.bat' -append -Encoding ASCII
echo "set LRX=$($retValues[3])" | out-file 'st_importtif.bat' -append -Encoding ASCII
echo "set LRY=$($retValues[4])" | out-file 'st_importtif.bat' -append -Encoding ASCII
echo "set NoData=$($retValues[5])" | out-file 'st_importtif.bat' -append -Encoding ASCII
}

else
{
 echo "set EndScript=100001" | out-file 'st_Refno.txt' -Encoding ASCII
}
