import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;


public class Download {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		// http://oiswww.eumetsat.org/SDDI/html/grib.html
		// http://oiswww.eumetsat.org/SDDI/html/js/grib_data_content.js
		// http://oiswww.eumetsat.org/SDDI/html/js/grib_data_generator.js
		
		if (args.length < 3) {
			System.out.println("Usage: java download <url> <destination_path> <pattern>+");
			System.out.println("Example: java Download http://oiswww.eumetsat.org/SDDI/html/grib.html D:\\ M7_57.grb");
			System.out.println("         java Download http://oiswww.eumetsat.org/SDDI/html/grib.html D:\\ M9_00.grb");
			System.out.println("         java Download http://oiswww.eumetsat.org/SDDI/html/grib.html D:\\ M7_57.grb M9_00.grb");
			System.out.println("Note: use quotes for paths with spaces.");
			
		} else {
//			String startUrl = "http://oiswww.eumetsat.org/SDDI/html/grib.html";
//			String destination = "D:\\";
			String startUrl = args[0];
			String destination = args[1];
			String [] patterns = new String[args.length - 2];
			for (int i = 2; i < args.length; ++i)
				patterns[i-2] = args[i];			
			download(startUrl, destination, patterns);
		}
		
	}
		
	static private void download(String startUrl, String destination, String [] patterns) {
		try {
			String base = startUrl.substring(0, startUrl.lastIndexOf('/'));

			System.out.println("Fetching '" + startUrl + "'");
			URL url = new URL(startUrl);
			BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
			
			String contentUrl = null;
			String generatorUrl = null;
			
			String line = reader.readLine();
			
			while (line != null && (contentUrl == null || generatorUrl == null)) {
				String str = findString(line, "content.js");
				if (str != null)
					contentUrl = base + "/" + str;
				str = findString(line, "generator.js");
				if (str != null)
					generatorUrl = base + "/" + str;
				line = reader.readLine();
			}
			
			reader.close();
			
			if (contentUrl != null && generatorUrl != null) {
				String data = null;
				
				System.out.println("Fetching '" + generatorUrl + "'");
				url = new URL(generatorUrl);
				reader = new BufferedReader(new InputStreamReader(url.openStream()));
				line = reader.readLine();
				
				while (line != null && data == null) {
					String str = findString(line, "data");
					if (str != null)
						data = base + "/" + str;
					line = reader.readLine();
				}
				
				reader.close();
				
				if (data != null) {
					System.out.println("Fetching '" + contentUrl + "'");
					url = new URL(contentUrl);
					reader = new BufferedReader(new InputStreamReader(url.openStream()));

					line = reader.readLine();
					while (line != null) {
						for (String pattern : patterns) {
							String str = findString(line, pattern);
							if (str != null) {
								String file = data + "/" + str;
								DownloadFile(file, destination, false);
							}
						}
						line = reader.readLine();
					}
					reader.close();
				}				
			}
			
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}
	
	static private String findString(String line, String pattern) {
		String ret = null;		
		int start = line.indexOf(pattern);		
		if (start >= 1) {
			int leftQuote = line.lastIndexOf('"', start);
			int rightQuote = line.indexOf('"', start);
			if (leftQuote >= 0 && rightQuote >= 0 && leftQuote < rightQuote && rightQuote < line.length())
				ret = line.substring(leftQuote + 1, rightQuote);
		}
		return ret;		
	}
	
	private static final int bufSize = 65536;
	private static final byte [] buf = new byte[bufSize]; 
	
	private static void DownloadFile(String file, String destination, boolean force) throws IOException {
		String slash = (destination != null && (destination.endsWith("/") || destination.endsWith("\\")))?"":"\\";
		String outFile = destination + slash + file.substring(file.lastIndexOf('/') + 1);
		File f = new File(outFile);
		if (force || (!f.exists())) {
			System.out.println("Downloading file '" + file.substring(file.lastIndexOf('/') + 1) + "'");
			URL fileUrl = new URL(file);
			BufferedInputStream bis = new BufferedInputStream(fileUrl.openStream());
			BufferedOutputStream ost = new BufferedOutputStream(new FileOutputStream(outFile));
	
			int total = bis.read(buf);
			while (total > -1) {
				ost.write(buf, 0, total);
				total = bis.read(buf);
			}
			ost.close();
			bis.close();
		} else {
			System.out.println("Skipping file '" + file.substring(file.lastIndexOf('/') + 1) + "' as it already exists");
		}
	}

}
