/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import ucar.nc2.constants.AxisType;

public enum NcAxisType {
    LON(AxisType.Lon),
    LAT(AxisType.Lat),
    VERT(AxisType.Pressure, AxisType.Height, AxisType.GeoZ),
    GEOX(AxisType.GeoX),
    GEOY(AxisType.GeoY),
    TIME(AxisType.Time),
    X(new AxisType[]{null}),
    Y(new AxisType[]{null}),
    FACENUM(new AxisType[]{null}),
    SPECTRAL(AxisType.Spectral);

    private final AxisType[] njTypes_;

    private NcAxisType(AxisType ... njTypes) {
        this.njTypes_ = njTypes;
    }

    private AxisType[] getNjTypes() {
        return this.njTypes_;
    }

    private NcAxisType matchesNjType(AxisType njType) {
        for (NcAxisType axType : NcAxisType.values()) {
            for (AxisType nj : axType.getNjTypes()) {
                if (njType != nj) continue;
                return axType;
            }
        }
        return null;
    }
}

